/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class GSMapHandler {
    private static final ResourceLocation haumeaRingTexture = new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/sol/haumea_rings.png");
    final Minecraft minecraft = FMLClientHandler.instance().getClient();
    public Random rand;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.getRingColorR() == 1.1f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorB() == 0.0f) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.7f, 0.0f, 0.0f);
        }
        if (renderEvent.celestialBody.getRingColorG() == 1.1f && renderEvent.celestialBody.getRingColorB() == 0.0f && renderEvent.celestialBody.getRingColorR() == 0.0f) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.0f, 0.7f, 0.0f);
        }
        if (renderEvent.celestialBody.getRingColorB() == 1.1f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorR() == 0.0f) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.0f, 0.0f, 0.7f);
        }
        if (renderEvent.celestialBody.getRingColorR() == 0.0f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorB() == 0.0f) {
            this.RingRenderNull(renderEvent, renderEvent.celestialBody);
        }
        if (renderEvent.celestialBody.equals((Object)GalacticraftCore.planetOverworld)) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.0f, 0.7f, 0.0f);
        }
    }

    public void RingRenderNull(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody) {
        renderEvent.setCanceled(true);
    }

    public void RingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody, float par1, float par2, float par3) {
        float temp;
        int i;
        Vector3f mapPos = renderEvent.parentOffset;
        float sum = renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance - renderEvent.celestialBody.getRelativeDistanceFromCenter().scaledDistance;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
            GL11.glColor4f((float)par1, (float)par2, (float)par3, (float)0.5f);
        } else {
            GL11.glColor4f((float)0.3f, (float)0.1f, (float)0.1f, (float)0.0f);
        }
        renderEvent.setCanceled(true);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        float min = 72.0f;
        float max = 78.0f;
        if (aroundBody instanceof Planet) {
            min = 72.0f;
            max = 78.0f;
        } else if (aroundBody instanceof Moon) {
            max = 0.6666667f;
            min = 0.5263158f;
        }
        float x = max * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance + sum);
        float y = 0.0f;
        GL11.glBegin((int)2);
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance - sum);
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)par1, (float)par2, (float)par3, (float)0.1f);
        GL11.glBegin((int)7);
        x = min * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance - sum);
        y = 0.0f;
        float x2 = max * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance + sum);
        float y2 = 0.0f;
        for (int i2 = 0; i2 < 90; ++i2) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
            temp = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBodyRender(CelestialBodyRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)SolarSystemBodies.planetKuiperBelt)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (renderEvent.celestialBody.equals((Object)SolarSystemBodies.planetHaumea)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 1000.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (renderEvent.celestialBody.getRingColorR() == 1.0f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorB() == 0.0f) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        if (this.minecraft.field_71462_r instanceof GuiCelestialSelection) {
            if (event.celestialBody == SolarSystemBodies.planetSaturn) {
                this.minecraft.field_71446_o.func_110577_a(ClientProxyCore.saturnRingTexture);
                float size = (float)((GuiCelestialSelection)this.minecraft.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                ((GuiCelestialSelection)this.minecraft.field_71462_r).drawTexturedModalRect(-7.5f * size, -1.75f * size, 16.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 2.0f, false, false, 30.0f, 7.0f);
            } else if (event.celestialBody == SolarSystemBodies.planetUranus) {
                this.minecraft.field_71446_o.func_110577_a(ClientProxyCore.uranusRingTexture);
                float size = (float)((GuiCelestialSelection)this.minecraft.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                ((GuiCelestialSelection)this.minecraft.field_71462_r).drawTexturedModalRect(-1.75f * size, -7.0f * size, 8.5f * size, 16.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            } else if (event.celestialBody == SolarSystemBodies.planetHaumea) {
                this.minecraft.field_71446_o.func_110577_a(haumeaRingTexture);
                float size = (float)((GuiCelestialSelection)this.minecraft.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ((GuiCelestialSelection)this.minecraft.field_71462_r).drawTexturedModalRect(-4.45f * size, -8.0f * size, 9.5f * size, 16.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            }
        }
    }
}

