/*
 * Decompiled with CFR 0.152.
 */
package net.rom.gctweaks.gc.features;

import asmodeuscore.core.configs.AsmodeusConfig;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import net.minecraftforge.common.config.Configuration;
import net.rom.gctweaks.base.Feature;
import net.rom.gctweaks.base.core.compat.CompatMods;

public class FixAsmodeusMapIcons
extends Feature {
    public static boolean fixIcons;

    @Override
    public String comment() {
        return "Fixes the Planet/Star icon sizes from More Planets & ZollernGalaxy";
    }

    @Override
    public String[] category() {
        return new String[]{"fix-icons"};
    }

    @Override
    public void syncConfig(Configuration config, String[] category) {
        fixIcons = config.get(category[0], "fixAsmodeusMapIcons", false, "Set to true to enable Fix Icons feature\nOnly affects icons if enableNewGalaxyMap is enabled in 'Asmodeuscore/core.conf'").getBoolean();
    }

    @Override
    public void postInit() {
        if (fixIcons && (CompatMods.ZOLLERN.isLoaded() || CompatMods.MOREPLANETS.isLoaded()) && AsmodeusConfig.enableNewGalaxyMap) {
            FixAsmodeusMapIcons.fixPlanetIcons();
        }
    }

    public static void fixPlanetIcons() {
        for (Map.Entry planet : GalaxyRegistry.getRegisteredPlanets().entrySet()) {
            ((Planet)planet.getValue()).setRelativeSize(1.0f);
        }
        for (Map.Entry star : GalaxyRegistry.getRegisteredSolarSystems().entrySet()) {
            ((SolarSystem)star.getValue()).getMainStar().setRelativeSize(1.0f);
        }
    }
}

