/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.utils;

import java.util.Optional;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;

public enum Gamemode {
    SURVIVAL(0, GameModes.SURVIVAL),
    CREATIVE(1, GameModes.CREATIVE),
    ADVENTURE(2, GameModes.ADVENTURE),
    SPECTATOR(3, GameModes.SPECTATOR);

    int index;
    GameMode gamemode;

    private Gamemode(int index, GameMode gamemode) {
        this.index = index;
        this.gamemode = gamemode;
    }

    public int getIndex() {
        return this.index;
    }

    public GameMode getGameMode() {
        return this.gamemode;
    }

    public static Optional<GameMode> get(String name) {
        Gamemode[] gamemodes;
        Optional<GameMode> optional = Optional.empty();
        for (Gamemode gamemode : gamemodes = Gamemode.values()) {
            if (!gamemode.getGameMode().getName().equals(name)) continue;
            optional = Optional.of(gamemode.getGameMode());
            break;
        }
        return optional;
    }

    public static Optional<GameMode> get(int index) {
        Gamemode[] gamemodes;
        Optional<GameMode> optional = Optional.empty();
        for (Gamemode gamemode : gamemodes = Gamemode.values()) {
            if (gamemode.getIndex() != index) continue;
            optional = Optional.of(gamemode.getGameMode());
            break;
        }
        return optional;
    }
}

