/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.managers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcsimonflash.sponge.activetime.ActiveTime;
import com.mcsimonflash.sponge.activetime.managers.Util;
import com.mcsimonflash.sponge.activetime.objects.ConfigHolder;
import com.mcsimonflash.sponge.activetime.objects.Milestone;
import com.mcsimonflash.sponge.activetime.objects.ServerReport;
import com.mcsimonflash.sponge.activetime.objects.TimeHolder;
import com.mcsimonflash.sponge.activetime.objects.UserReport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;

public class Storage {
    private static Path storDir = ActiveTime.getInstance().getDirectory().resolve("storage");
    private static Path logsDir = storDir.resolve("logs");
    private static ConfigHolder players;
    private static ConfigHolder current;
    public static List<Text> leaderboard;
    public static Map<String, Milestone> milestones;
    public static Map<UUID, TimeHolder> times;
    public static Task updateTask;
    public static Task saveTask;
    public static Task milestoneTask;
    public static Task limitTask;

    private static void initializeNodes() {
        try {
            Files.createDirectories(logsDir, new FileAttribute[0]);
            players = new ConfigHolder(storDir.resolve("players.stor"), false);
            int i = 0;
            for (CommentedConfigurationNode node : players.getNode(new Object[0]).getChildrenMap().values()) {
                for (CommentedConfigurationNode milestone : node.getNode(new Object[]{"milestones"}).getChildrenMap().values()) {
                    if (!(milestone.getValue() instanceof Boolean)) continue;
                    if (milestone.getBoolean(false)) {
                        milestone.setValue((Object)Optional.ofNullable(milestones.get(milestone.getKey())).map(Milestone::getActiveTime).orElse(1));
                    } else {
                        milestone.setValue(null);
                    }
                    ++i;
                }
            }
            if (i != 0) {
                ActiveTime.getLogger().warn("Updated " + i + " legacy milestone" + (i == 1 ? "" : "s") + " in the players.stor file.");
                players.save();
            }
            Storage.syncCurrentDate();
        }
        catch (IOException e) {
            ActiveTime.getLogger().error("Unable to load storage files! Error:");
            e.printStackTrace();
        }
    }

    private static void syncCurrentDate() {
        try {
            current = new ConfigHolder(logsDir.resolve(LocalDate.now() + ".stor"), false);
        }
        catch (IOException e) {
            ActiveTime.getLogger().error("Unable to initiate daily log file!");
        }
    }

    public static void save() {
        Util.createTask("ActiveTime SaveConfig Sync Processor", t -> {
            players.save();
            current.save();
            Storage.syncCurrentDate();
        }, 0, false);
    }

    public static void readStorage() {
        Storage.initializeNodes();
    }

    public static String getUsername(UUID uuid) {
        return players.getNode(uuid.toString(), "username").getString(uuid.toString());
    }

    public static void setUsername(UUID uuid, String name) {
        players.getNode(uuid.toString(), "username").setValue((Object)name);
    }

    private static TimeHolder getTimeHolder(CommentedConfigurationNode node) {
        return new TimeHolder(node.getNode(new Object[]{"activetime"}).getInt(), node.getNode(new Object[]{"afktime"}).getInt());
    }

    private static void setTimeHolder(CommentedConfigurationNode node, TimeHolder time) {
        node.getNode(new Object[]{"activetime"}).setValue((Object)time.getActiveTime());
        node.getNode(new Object[]{"afktime"}).setValue((Object)time.getAfkTime());
    }

    public static TimeHolder getTotalTime(UUID uuid) {
        return Storage.getTimeHolder(players.getNode(uuid.toString()));
    }

    public static void setTotalTime(UUID uuid, TimeHolder time) {
        Storage.setTimeHolder(players.getNode(uuid.toString()), time);
    }

    public static TimeHolder getDailyTime(UUID uuid) {
        return Storage.getTimeHolder(current.getNode(uuid.toString()));
    }

    public static void setDailyTime(UUID uuid, TimeHolder time) {
        Storage.setTimeHolder(current.getNode(uuid.toString()), time);
    }

    public static Optional<TimeHolder> getTime(UUID uuid, LocalDate date) {
        Path path = logsDir.resolve(date + ".stor");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Optional.of(Storage.getTimeHolder(new ConfigHolder(path, false).getNode(uuid.toString())));
            }
            catch (IOException e) {
                ActiveTime.getLogger().error("An error occurred loading the log file for " + date + ".");
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    public static int getMilestoneTime(UUID uuid, Milestone milestone) {
        return players.getNode(uuid.toString(), "milestones", milestone.getName()).getInt(0);
    }

    public static void setMilestoneTime(UUID uuid, Milestone milestone, int time) {
        players.getNode(uuid.toString(), "milestones", milestone.getName()).setValue((Object)time);
    }

    public static void buildLeaderboard() {
        AtomicInteger i = new AtomicInteger(1);
        leaderboard = players.getNode(new Object[0]).getChildrenMap().values().stream().map(n -> Maps.immutableEntry((Object)n.getNode(new Object[]{"username"}).getString((String)n.getKey()), (Object)Storage.getTimeHolder(n))).sorted(Comparator.comparingInt(o -> -((TimeHolder)o.getValue()).getActiveTime())).map(e -> "&b" + i.getAndIncrement() + "&7: &f" + (String)e.getKey() + " &7- " + Util.printTime(((TimeHolder)e.getValue()).getActiveTime())).map(Util::toText).collect(Collectors.toList());
    }

    public static void generateServerReport(ServerReport report) {
        LocalDate week = report.from.minusDays(report.from.getDayOfWeek().getValue());
        LocalDate month = report.from.withDayOfMonth(1);
        LocalDate date = report.to;
        while (!date.isBefore(report.from)) {
            week = date.getDayOfWeek().getValue() == 7 ? date : week;
            month = date.getDayOfMonth() == 1 ? date : month;
            Path path = logsDir.resolve(date + ".stor");
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    for (CommentedConfigurationNode node : new ConfigHolder(path, false).getNode(new Object[0]).getChildrenMap().values()) {
                        UUID uuid = UUID.fromString((String)node.getKey());
                        UserReport user = report.userReports.computeIfAbsent(uuid, u -> new UserReport((UUID)u, report.from, report.to));
                        TimeHolder time = Storage.getTimeHolder(node);
                        user.dailyTimes.put(date, time);
                        user.weeklyTimes.computeIfAbsent(week, w -> new TimeHolder()).add(time);
                        user.monthlyTimes.computeIfAbsent(month, m -> new TimeHolder()).add(time);
                    }
                }
                catch (IOException e) {
                    ActiveTime.getLogger().error("An error occurred loading the log file for " + date + ".");
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    ActiveTime.getLogger().error("The log file for " + date + " is malformed.");
                }
            }
            date = date.minusDays(1L);
        }
        if (!report.userReports.isEmpty()) {
            report.userReports.values().forEach(u -> {
                u.monthlyTimes.values().forEach(u.total::add);
                report.total.add(u.total);
                if (!u.dailyTimes.isEmpty()) {
                    u.dailyAverage.set(u.total.getActiveTime() / u.dailyTimes.size(), u.total.getAfkTime() / u.dailyTimes.size());
                    u.weeklyAverage.set(u.total.getActiveTime() / u.weeklyTimes.size(), u.total.getAfkTime() / u.weeklyTimes.size());
                    u.monthlyAverage.set(u.total.getActiveTime() / u.monthlyTimes.size(), u.total.getAfkTime() / u.monthlyTimes.size());
                    report.dailyAverage.add(u.dailyAverage);
                    report.weeklyAverage.add(u.weeklyAverage);
                    report.monthlyAverage.add(u.monthlyAverage);
                }
            });
        }
    }

    public static void generateUserReport(UserReport report) {
        LocalDate week = report.from.minusDays(report.from.getDayOfWeek().getValue());
        LocalDate month = report.from.withDayOfMonth(1);
        LocalDate date = report.from;
        while (!date.isAfter(report.to)) {
            TimeHolder time = Storage.getTime(report.uuid, date).orElseGet(TimeHolder::new);
            report.dailyTimes.put(date, time);
            week = date.getDayOfWeek().getValue() == 7 ? date : week;
            report.weeklyTimes.computeIfAbsent(week, w -> new TimeHolder()).add(time);
            month = date.getDayOfMonth() == 1 ? date : month;
            report.monthlyTimes.computeIfAbsent(month, m -> new TimeHolder()).add(time);
            date = date.plusDays(1L);
        }
        report.monthlyTimes.values().forEach(report.total::add);
        if (!report.dailyTimes.isEmpty()) {
            report.dailyAverage.set(report.total.getActiveTime() / report.dailyTimes.size(), report.total.getAfkTime() / report.dailyTimes.size());
            report.weeklyAverage.set(report.total.getActiveTime() / report.weeklyTimes.size(), report.total.getAfkTime() / report.weeklyTimes.size());
            report.monthlyAverage.set(report.total.getActiveTime() / report.monthlyTimes.size(), report.total.getAfkTime() / report.monthlyTimes.size());
        }
    }

    static {
        leaderboard = Lists.newLinkedList();
        milestones = Maps.newHashMap();
        times = Maps.newHashMap();
    }
}

