/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.command;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import com.mcsimonflash.sponge.cmdscheduler.CmdScheduler;
import com.mcsimonflash.sponge.cmdscheduler.command.Base;
import com.mcsimonflash.sponge.cmdscheduler.internal.Config;
import com.mcsimonflash.sponge.cmdscheduler.task.CommandTask;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

@Aliases(value={"delete"})
@Permission(value="cmdscheduler.command.delete.base")
public class Delete
extends Command {
    @Inject
    private Delete(Command.Settings settings) {
        super(settings.usage(CmdUtils.usage((String)"/cmdscheduler delete ", (Text)CmdUtils.info((String)"Delete", (String)"Deletes a task. If the task is defined in the config, it must be deleted there manually.\n", (String)"", (String)"delete\n", (String)"cmdscheduler.command.delete.base"), (Text[])new Text[]{Base.TASK_ARG})).elements(new CommandElement[]{Arguments.choices(Config.tasks, (ImmutableMap)ImmutableMap.of((Object)"no-choice", (Object)"Input <arg> is not the name of a task!")).toElement("task")}));
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        CommandTask task = (CommandTask)args.getOne("task").get();
        task.getTask().stop(CmdScheduler.get().getContainer());
        Config.tasks.remove(task.getName().toLowerCase());
        src.sendMessage(CmdScheduler.getMessage(src, "cmdscheduler.command.delete.success", "task", task.getName()));
        return CommandResult.success();
    }
}

