/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.discordcraft.commands;

import me.dierke9.discordcraft.util.RFToolsDimensionManager;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class DimInfo
extends CommandBase {
    private static RFToolsDimensionManager dimensionManager;

    public String func_71517_b() {
        return "diminfo";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/diminfo";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new WrongUsageException("Command can only be run by a player", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        DimensionType dimtype = player.field_70170_p.field_73011_w.func_186058_p();
        int id = player.field_70170_p.field_73011_w.getDimension();
        World world = player.field_70170_p;
        String group = this.getGroupId(id, world);
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("Current dimension\nDimId: %s\nDimName: %s\nGroup: %s", id, dimtype.func_186065_b(), group)));
    }

    public String getGroupId(int dimid, World world) {
        CelestialBody body;
        if (dimid == 0 || dimid == -1) {
            return "default";
        }
        if (Loader.isModLoaded((String)"rftoolsdim") && DimInfo.getrfToolsDimensionManager().isRFToolsDimension(world, dimid)) {
            return "rftools";
        }
        if (Loader.isModLoaded((String)"galacticraftcore") && (body = GalaxyRegistry.getCelestialBodyFromDimensionID((int)dimid)) != null) {
            switch (body.getClass().getSimpleName().toLowerCase()) {
                case "planet": {
                    return "gcplanet";
                }
                case "moon": {
                    return "gcmoon";
                }
                case "satellite": {
                    return "gcsatellite";
                }
            }
        }
        return "default";
    }

    private static RFToolsDimensionManager getrfToolsDimensionManager() {
        if (Loader.isModLoaded((String)"rftoolsdim")) {
            dimensionManager = new RFToolsDimensionManager();
            return dimensionManager;
        }
        return null;
    }
}

