/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.machinemuse.numina.basemod.MuseLogger;
import net.machinemuse.numina.client.gui.clickable.ClickableLabel;
import net.machinemuse.numina.client.gui.clickable.ClickableSlider;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.gui.scrollable.ScrollableLabel;
import net.machinemuse.numina.client.gui.scrollable.ScrollableRectangle;
import net.machinemuse.numina.client.gui.scrollable.ScrollableSlider;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.DrawableMuseRect;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.numina.math.geometry.MuseRect;
import net.machinemuse.numina.math.geometry.MuseRelativeRect;
import net.machinemuse.powersuits.gui.GuiIcons;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.network.MPSPackets;
import net.machinemuse.powersuits.network.packets.MusePacketColourInfo;
import net.machinemuse.powersuits.utils.nbt.MPSNBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class ColourPickerFrame
extends ScrollableFrame {
    public ItemSelectionFrame itemSelector;
    public ScrollableSlider rslider;
    public ScrollableSlider gslider;
    public ScrollableSlider bslider;
    public ScrollableSlider aslider;
    ScrollableColourBox colourBox;
    String COLOUR_PREFIX = I18n.func_135052_a((String)"gui.powersuits.colourPrefix", (Object[])new Object[0]);
    public ScrollableLabel colourLabel;
    public ScrollableSlider selectedSlider;
    public int selectedColour;
    public int decrAbove;
    ScrollableRectangle[] rectangles;

    public ColourPickerFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame itemSelector) {
        super(topleft, bottomright, borderColour, insideColour);
        this.itemSelector = itemSelector;
        this.rectangles = new ScrollableRectangle[6];
        this.totalsize = 120;
        this.rslider = this.getScrollableSlider("red", null, 0);
        this.gslider = this.getScrollableSlider("green", (ScrollableRectangle)this.rslider, 1);
        this.bslider = this.getScrollableSlider("blue", (ScrollableRectangle)this.gslider, 2);
        this.aslider = this.getScrollableSlider("alpha", (ScrollableRectangle)this.bslider, 3);
        this.colourBox = new ScrollableColourBox(new MuseRelativeRect(this.border.left(), this.aslider.bottom(), this.border.right(), this.aslider.bottom() + 25.0));
        this.colourBox.setBelow((MuseRect)this.aslider);
        this.rectangles[4] = this.colourBox;
        MuseRelativeRect colourLabelBox = new MuseRelativeRect(this.border.left(), this.colourBox.bottom(), this.border.right(), this.colourBox.bottom() + 20.0);
        this.colourLabel = new ScrollableLabel(new ClickableLabel(this.COLOUR_PREFIX, new MusePoint2D(colourLabelBox.centerx(), colourLabelBox.centery())), colourLabelBox);
        this.colourLabel.setBelow((MuseRect)this.colourBox);
        this.rectangles[5] = this.colourLabel;
        this.selectedSlider = null;
        this.selectedColour = 0;
        this.decrAbove = -1;
        this.enable();
    }

    public ScrollableSlider getScrollableSlider(String id, ScrollableRectangle prev, int index) {
        MuseRelativeRect newborder = new MuseRelativeRect(this.border.left(), prev != null ? prev.bottom() : this.border.top(), this.border.right(), (prev != null ? prev.bottom() : this.border.top()) + 18.0);
        ClickableSlider slider = new ClickableSlider(new MusePoint2D(newborder.centerx(), newborder.centery()), newborder.width() - 15.0, id, I18n.func_135052_a((String)("powersuits.tradeoff." + id), (Object[])new Object[0]));
        ScrollableSlider scrollableSlider = new ScrollableSlider(slider, newborder);
        scrollableSlider.setBelow((MuseRect)(prev != null ? prev : null));
        this.rectangles[index] = scrollableSlider;
        return scrollableSlider;
    }

    public int[] colours() {
        return this.getOrCreateColourTag() != null ? this.getOrCreateColourTag().func_150302_c() : new int[]{};
    }

    public NBTTagIntArray getOrCreateColourTag() {
        if (this.itemSelector.getSelectedItem() == null) {
            return null;
        }
        NBTTagCompound renderSpec = MPSNBTUtils.getMuseRenderTag(this.itemSelector.getSelectedItem().getItem());
        if (renderSpec.func_74764_b("colours") && renderSpec.func_74781_a("colours") instanceof NBTTagIntArray) {
            return (NBTTagIntArray)renderSpec.func_74781_a("colours");
        }
        Item item = this.itemSelector.getSelectedItem().getItem().func_77973_b();
        if (item instanceof ItemPowerArmor) {
            ItemPowerArmor itemPowerArmor = (ItemPowerArmor)item;
            int[] intArray = new int[]{itemPowerArmor.getColorFromItemStack(this.itemSelector.getSelectedItem().getItem()).getInt()};
            renderSpec.func_74783_a("colours", intArray);
        } else {
            int[] intArray2 = new int[]{Colour.WHITE.getInt()};
            renderSpec.func_74783_a("colours", intArray2);
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_70170_p.field_72995_K) {
            MPSPackets.sendToServer((IMessage)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
        }
        return (NBTTagIntArray)renderSpec.func_74781_a("colours");
    }

    public NBTTagIntArray setColourTagMaybe(List<Integer> intList) {
        if (this.itemSelector.getSelectedItem() == null) {
            return null;
        }
        NBTTagCompound renderSpec = MPSNBTUtils.getMuseRenderTag(this.itemSelector.getSelectedItem().getItem());
        renderSpec.func_74782_a("colours", (NBTBase)new NBTTagIntArray(intList));
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_70170_p.field_72995_K) {
            MPSPackets.sendToServer((IMessage)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
        }
        return (NBTTagIntArray)renderSpec.func_74781_a("colours");
    }

    public ArrayList<Integer> importColours() {
        return new ArrayList<Integer>();
    }

    public void refreshColours() {
    }

    public void onMouseUp(double x, double y, int button) {
        if (this.isEnabled()) {
            this.selectedSlider = null;
        }
    }

    public DrawableMuseRect getBorder() {
        return this.border;
    }

    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
        if (this.isEnabled()) {
            if (this.selectedSlider != null) {
                this.selectedSlider.getSlider().setValueByX(mousex);
                if (this.colours().length > this.selectedColour) {
                    this.colours()[this.selectedColour] = Colour.getInt((double)this.rslider.getValue(), (double)this.gslider.getValue(), (double)this.bslider.getValue(), (double)this.aslider.getValue());
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player.field_70170_p.field_72995_K) {
                        MPSPackets.sendToServer((IMessage)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
                    }
                }
            } else if (this.itemSelector.getSelectedItem() != null && this.colours().length > 0 && this.selectedColour <= this.colours().length - 1) {
                this.onSelectColour(this.selectedColour);
            }
        }
    }

    public void draw() {
        if (this.isVisibile()) {
            this.currentscrollpixels = Math.min(this.currentscrollpixels, this.getMaxScrollPixels());
            if (this.colours().length > this.selectedColour) {
                this.colourLabel.setText(this.COLOUR_PREFIX + " 0X" + new Colour(this.colours()[this.selectedColour]).hexColour());
            }
            super.preDraw();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(-this.currentscrollpixels), (float)0.0f);
            for (ScrollableRectangle f : this.rectangles) {
                f.draw();
            }
            GL11.glPopMatrix();
            super.postDraw();
        }
    }

    public List<String> getToolTip(int x, int y) {
        return null;
    }

    public void onSelectColour(int i) {
        Colour c = new Colour(this.colours()[i]);
        this.rslider.setValue(c.r);
        this.gslider.setValue(c.g);
        this.bslider.setValue(c.b);
        this.aslider.setValue(c.a);
        this.selectedColour = i;
    }

    public void onMouseDown(double x, double y, int button) {
        if (this.isEnabled()) {
            this.selectedSlider = this.rslider.hitBox(x, y += (double)this.currentscrollpixels) ? this.rslider : (this.gslider.hitBox(x, y) ? this.gslider : (this.bslider.hitBox(x, y) ? this.bslider : (this.aslider.hitBox(x, y) ? this.aslider : null)));
            this.colourBox.addColour(x, y);
            this.colourBox.removeColour(x, y);
            if (this.colourLabel.hitbox(x, y) && this.colours().length > this.selectedColour) {
                StringSelection selection = new StringSelection(new Colour(this.selectedColour).hexColour());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        }
    }

    public int[] getIntArray(NBTTagIntArray e) {
        if (e == null) {
            return new int[0];
        }
        return e.func_150302_c();
    }

    class ScrollableColourBox
    extends ScrollableRectangle {
        public ScrollableColourBox(MuseRelativeRect relativeRect) {
            super(relativeRect);
        }

        boolean addColour(double x, double y) {
            if (y > this.centery() + 8.5 && y < this.centery() + 16.5) {
                int colourCol = (int)(x - this.left() - 8.0) / 8;
                if (colourCol >= 0 && colourCol < ColourPickerFrame.this.colours().length) {
                    ColourPickerFrame.this.onSelectColour(colourCol);
                } else if (colourCol == ColourPickerFrame.this.colours().length) {
                    MuseLogger.logDebug((String)"Adding");
                    List<Integer> intList = Arrays.stream(ColourPickerFrame.this.getIntArray(ColourPickerFrame.this.getOrCreateColourTag())).boxed().collect(Collectors.toList());
                    intList.add(Colour.WHITE.getInt());
                    ColourPickerFrame.this.setColourTagMaybe(intList);
                }
                return true;
            }
            return false;
        }

        boolean removeColour(double x, double y) {
            if (y > this.centery() + 0.5 && y < this.centery() + 8.5 && x > this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8) && x < this.left() + 16.0 + (double)(ColourPickerFrame.this.selectedColour * 8)) {
                NBTTagIntArray nbtTagIntArray = ColourPickerFrame.this.getOrCreateColourTag();
                List<Integer> intList = Arrays.stream(ColourPickerFrame.this.getIntArray(nbtTagIntArray)).boxed().collect(Collectors.toList());
                if (intList.size() > 1 && ColourPickerFrame.this.selectedColour <= intList.size() - 1) {
                    intList.remove(ColourPickerFrame.this.selectedColour);
                    ColourPickerFrame.this.setColourTagMaybe(intList);
                    ColourPickerFrame.this.decrAbove = ColourPickerFrame.this.selectedColour;
                    if (ColourPickerFrame.this.selectedColour == ColourPickerFrame.this.getIntArray(nbtTagIntArray).length) {
                        --ColourPickerFrame.this.selectedColour;
                    }
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player.field_70170_p.field_72995_K) {
                        MPSPackets.sendToServer((IMessage)new MusePacketColourInfo((EntityPlayer)player, ColourPickerFrame.this.itemSelector.getSelectedItem().inventorySlot, nbtTagIntArray.func_150302_c()));
                    }
                }
                return true;
            }
            return false;
        }

        public void draw() {
            for (int i = 0; i < ColourPickerFrame.this.colours().length; ++i) {
                new GuiIcons.ArmourColourPatch(this.left() + 8.0 + (double)(i * 8), this.centery() + 8.0, new Colour(ColourPickerFrame.this.colours()[i]), null, null, null, null);
            }
            new GuiIcons.ArmourColourPatch(this.left() + 8.0 + (double)(ColourPickerFrame.this.colours().length * 8), this.centery() + 8.0, Colour.WHITE, null, null, null, null);
            new GuiIcons.SelectedArmorOverlay(this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8), this.centery() + 8.0, Colour.WHITE, null, null, null, null);
            new GuiIcons.MinusSign(this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8), this.centery(), Colour.RED, null, null, null, null);
            new GuiIcons.PlusSign(this.left() + 8.0 + (double)(ColourPickerFrame.this.colours().length * 8), this.centery() + 8.0, Colour.GREEN, null, null, null, null);
        }
    }
}

