/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cubex2.cs4.api.WrappedFluidStack;
import cubex2.cs4.plugins.vanilla.WrappedFluidStackImpl;
import java.lang.reflect.Type;
import org.apache.commons.lang3.tuple.Pair;

class WrappedFluidStackDeserializer
implements JsonDeserializer<WrappedFluidStack> {
    WrappedFluidStackDeserializer() {
    }

    public WrappedFluidStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            return this.fromString(json, context);
        }
        return this.fromObject(json, context);
    }

    private WrappedFluidStack fromString(JsonElement json, JsonDeserializationContext context) {
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (primitive.isString()) {
            if (primitive.getAsString().isEmpty()) {
                return WrappedFluidStack.EMPTY;
            }
            Pair<String, Integer> pair = this.parseFluidPart(primitive.getAsString());
            return new WrappedFluidStackImpl((String)pair.getLeft(), (Integer)pair.getRight());
        }
        throw new JsonParseException("Invalid element for stack.");
    }

    private WrappedFluidStack fromObject(JsonElement json, JsonDeserializationContext context) {
        WrappedFluidStackImpl stack = new WrappedFluidStackImpl();
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("fluid")) {
            JsonElement element = jsonObject.get("fluid");
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                Pair<String, Integer> pair = this.parseFluidPart(element.getAsString());
                element = new JsonPrimitive((String)pair.getLeft());
                stack.amount = (Integer)pair.getRight();
            }
            stack.fluid = (String)context.deserialize(element, String.class);
        }
        if (jsonObject.has("amount")) {
            stack.amount = jsonObject.get("amount").getAsInt();
        }
        return stack;
    }

    private Pair<String, Integer> parseFluidPart(String input) {
        int amount = 1000;
        if (input.contains("@")) {
            String amountPart = input.substring(input.lastIndexOf(64) + 1);
            input = input.substring(0, input.lastIndexOf(64));
            amount = Integer.parseInt(amountPart);
        }
        return Pair.of((Object)input, (Object)amount);
    }
}

