/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.jobs.JobBasedRequirement;
import com.erigitic.jobs.JobManager;
import com.erigitic.jobs.TEAction;
import com.erigitic.jobs.TEActionReward;
import com.erigitic.jobs.TEJob;
import com.erigitic.jobs.TEJobSet;
import com.erigitic.main.TotalEconomy;
import com.erigitic.util.MessageManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class JobCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private JobManager jobManager;
    private MessageManager messageManager;

    public JobCommand(TotalEconomy totalEconomy, AccountManager accountManager, JobManager jobManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.jobManager = jobManager;
        this.messageManager = messageManager;
    }

    public CommandSpec commandSpec() {
        Set jobSetCommand = new Set(this.totalEconomy, this.jobManager, this.messageManager);
        Info jobInfoCommand = new Info(this.totalEconomy, this.jobManager);
        Reload jobReloadCommand = new Reload(this.jobManager);
        Toggle jobToggleCommand = new Toggle(this.accountManager);
        return CommandSpec.builder().child((CommandCallable)jobSetCommand.commandSpec(), new String[]{"set", "s"}).child((CommandCallable)jobInfoCommand.commandSpec(), new String[]{"info", "i"}).child((CommandCallable)jobReloadCommand.commandSpec(), new String[]{"reload"}).child((CommandCallable)jobToggleCommand.commandSpec(), new String[]{"toggle", "t"}).description((Text)Text.of((String)"Display job information")).permission("totaleconomy.command.job").arguments(GenericArguments.none()).executor((CommandExecutor)this).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (src instanceof Player) {
            Player player = (Player)((Player)src).getPlayer().get();
            String jobName = this.totalEconomy.getJobManager().getPlayerJob((User)player);
            HashMap<String, String> messageValues = new HashMap<String, String>();
            messageValues.put("job", this.jobManager.titleize(jobName));
            messageValues.put("curlevel", String.valueOf(this.jobManager.getJobLevel(jobName, (User)player)));
            messageValues.put("curexp", String.valueOf(this.jobManager.getJobExp(jobName, (User)player)));
            messageValues.put("exptolevel", String.valueOf(this.jobManager.getExpToLevel((User)player)));
            player.sendMessage(this.messageManager.getMessage("command.job.current", messageValues));
            player.sendMessage(this.messageManager.getMessage("command.job.level", messageValues));
            player.sendMessage(this.messageManager.getMessage("command.job.exp", messageValues));
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "Available Jobs: ", TextColors.GOLD, this.totalEconomy.getJobManager().getJobList()}));
            return CommandResult.success();
        }
        throw new CommandException((Text)Text.of((String)"You can't have a job!"));
    }

    private Text formatReward(TEActionReward reward) {
        Optional<Object> rewardCurrencyOpt = Optional.empty();
        if (reward.getCurrencyId() != null) {
            rewardCurrencyOpt = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + reward.getCurrencyId());
        }
        return Text.of((Object[])new Object[]{"(", reward.getExpReward(), " EXP) (", ((Currency)rewardCurrencyOpt.orElse(this.totalEconomy.getDefaultCurrency())).format(new BigDecimal(reward.getMoneyReward())), ")"});
    }

    private class Toggle
    implements CommandExecutor {
        private final String[] TOGGLE_PLAYER_OPTIONS = new String[]{"block-break-info", "block-place-info", "entity-kill-info", "entity-fish-info"};
        private final List<String> TOGGLE_PLAYER_OPTIONS_LIST = Arrays.asList(this.TOGGLE_PLAYER_OPTIONS);
        private AccountManager accountManager;

        public Toggle(AccountManager accountManager) {
            this.accountManager = accountManager;
        }

        public CommandSpec commandSpec() {
            return CommandSpec.builder().description((Text)Text.of((String)"Toggle job notifications on/off")).permission("totaleconomy.command.job.toggle").arguments(GenericArguments.optional((CommandElement)GenericArguments.requiringPermission((CommandElement)GenericArguments.string((Text)Text.of((String)"option")), (String)"totaleconomy.command.job.block_info"))).executor((CommandExecutor)this).build();
        }

        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            if (src instanceof Player) {
                Player sender = (Player)src;
                Optional optionOpt = args.getOne("option");
                if (!optionOpt.isPresent()) {
                    this.accountManager.toggleNotifications(sender);
                    return CommandResult.success();
                }
                String option = (String)optionOpt.get();
                int i = this.TOGGLE_PLAYER_OPTIONS_LIST.indexOf(option);
                if (i < 0) {
                    throw new CommandException(Text.of((Object[])new Object[]{"[TE] Unknown option: ", option}));
                }
                String value = this.accountManager.getUserOption("totaleconomy:" + option, (User)sender).orElse("0");
                value = value.equals("0") ? "1" : "0";
                this.accountManager.setUserOption("totaleconomy:" + option, (User)sender, value);
                src.sendMessage(JobCommand.this.messageManager.getMessage("jobs.toggle"));
                return CommandResult.success();
            }
            throw new CommandException((Text)Text.of((String)"[TE] This command can only be run by a player!"));
        }
    }

    private class Reload
    implements CommandExecutor {
        private JobManager jobManager;

        public Reload(JobManager jobManager) {
            this.jobManager = jobManager;
        }

        public CommandSpec commandSpec() {
            return CommandSpec.builder().description((Text)Text.of((String)"Reloads sets and jobs")).permission("totaleconomy.command.job.reload").executor((CommandExecutor)this).arguments(GenericArguments.none()).build();
        }

        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            if (!this.jobManager.reloadJobsAndSets()) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "[TE] Failed to reload sets and/or jobs!"}));
            }
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "[TE] Sets and jobs reloaded."}));
            return CommandResult.success();
        }
    }

    private class Info
    implements CommandExecutor {
        private TotalEconomy totalEconomy;
        private JobManager jobManager;
        private PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
        private PaginationList.Builder pageBuilder = this.paginationService.builder();

        public Info(TotalEconomy totalEconomy, JobManager jobManager) {
            this.totalEconomy = totalEconomy;
            this.jobManager = jobManager;
        }

        public CommandSpec commandSpec() {
            return CommandSpec.builder().description((Text)Text.of((String)"Prints out a list of items that reward exp and money for the current job")).permission("totaleconomy.command.job.info").executor((CommandExecutor)this).arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.flags().flag(new String[]{"e"}).buildWith(GenericArguments.none())), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"jobName")))}).build();
        }

        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            Optional optJobName = args.getOne("jobName");
            Optional<Object> optJob = Optional.empty();
            boolean extended = args.hasAny("e");
            if (!optJobName.isPresent() && src instanceof Player) {
                optJob = this.jobManager.getJob(this.jobManager.getPlayerJob((User)((Player)src)), true);
            }
            if (optJobName.isPresent()) {
                optJob = this.jobManager.getJob(((String)optJobName.get()).toLowerCase(), false);
            }
            if (!optJob.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Unknown job: \"" + optJobName.orElse("") + "\""}));
            }
            ArrayList<Text> lines = new ArrayList<Text>();
            for (String s : ((TEJob)optJob.get()).getSets()) {
                Optional<TEJobSet> optSet = this.jobManager.getJobSet(s);
                if (!optSet.isPresent()) continue;
                TEJobSet jobSet = optSet.get();
                for (TEAction action : jobSet.getActions()) {
                    Text listText;
                    if (action.isIdTraited()) {
                        String tab = new String(new char[action.getAction().length() + 2]).replace("\u0000", " ");
                        ArrayList texts = new ArrayList(action.getRewards().size());
                        action.getRewards().forEach((k, v) -> {
                            LiteralText metaText = Text.of((String)"");
                            if (action.isGrowing() && extended) {
                                metaText = Text.of((String)",growing=1");
                            }
                            Text rewardText = Text.of((Object[])new Object[]{"\n", tab, TextColors.GRAY, "{", action.getIdTrait(), Character.valueOf('='), k, metaText, "} ", TextColors.GOLD, JobCommand.this.formatReward(v)});
                            texts.add(rewardText);
                        });
                        listText = Text.join((Text[])texts.toArray(new Text[texts.size()]));
                    } else {
                        listText = Text.of((Object[])new Object[]{" ", JobCommand.this.formatReward(action.getReward().get())});
                        if (action.isGrowing() && extended) {
                            listText = Text.of((Object[])new Object[]{TextColors.GRAY, "{growing=1}", TextColors.GOLD, listText});
                        }
                    }
                    lines.add(Text.of((Object[])new Object[]{TextColors.GOLD, "[", this.jobManager.titleize(action.getAction()), "] ", TextColors.GRAY, action.getTargetId(), TextColors.GOLD, listText}));
                }
            }
            ((PaginationList.Builder)this.pageBuilder.reset()).header(Text.of((Object[])new Object[]{TextColors.GRAY, "Job information for ", TextColors.GOLD, optJobName.orElseGet(() -> this.jobManager.getPlayerJob((User)((Player)src))), "\n"})).contents(lines.toArray(new Text[lines.size()])).build().sendTo((MessageReceiver)src);
            return CommandResult.success();
        }
    }

    private class Set
    implements CommandExecutor {
        private TotalEconomy totalEconomy;
        private MessageManager messageManager;
        private JobManager jobManager;

        public Set(TotalEconomy totalEconomy, JobManager jobManager, MessageManager messageManager) {
            this.totalEconomy = totalEconomy;
            this.jobManager = jobManager;
            this.messageManager = messageManager;
        }

        public CommandSpec commandSpec() {
            return CommandSpec.builder().description((Text)Text.of((String)"Set your job")).permission("totaleconomy.command.job.set").executor((CommandExecutor)this).arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"jobName")), GenericArguments.optional((CommandElement)GenericArguments.requiringPermission((CommandElement)GenericArguments.userOrSource((Text)Text.of((String)"user")), (String)"totaleconomy.command.job.setother"))}).build();
        }

        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            User user;
            String jobName = args.getOne("jobName").get().toString().toLowerCase();
            Optional userOpt = args.getOne("user");
            if (userOpt.isPresent()) {
                user = (User)userOpt.get();
            } else if (src instanceof Player) {
                user = (Player)src;
            } else {
                return CommandResult.empty();
            }
            Optional<TEJob> optJob = this.totalEconomy.getJobManager().getJob(jobName, false);
            if (!optJob.isPresent()) {
                throw new CommandException((Text)Text.of((String)("Job " + jobName + " does not exist!")));
            }
            TEJob job = optJob.get();
            if (job.getRequirement().isPresent()) {
                JobBasedRequirement req = job.getRequirement().get();
                if (req.getRequiredPermission() != null && !user.hasPermission(req.getRequiredPermission())) {
                    throw new CommandException(Text.of((Object[])new Object[]{"Not permitted to join job \"", TextColors.GOLD, jobName, TextColors.RED, "\""}));
                }
                if (req.getRequiredJob() != null && req.getRequiredJobLevel() > this.totalEconomy.getJobManager().getJobLevel(req.getRequiredJob().toLowerCase(), user)) {
                    throw new CommandException(Text.of((Object[])new Object[]{"Insufficient level! Level ", TextColors.GOLD, req.getRequiredJobLevel(), TextColors.RED, " as a ", TextColors.GOLD, req.getRequiredJob(), TextColors.RED, " required!"}));
                }
            }
            if (!this.jobManager.setJob(user, jobName)) {
                throw new CommandException((Text)Text.of((String)"Failed to set job. Contact your administrator."));
            }
            if (user.getPlayer().isPresent()) {
                HashMap<String, String> messageValues = new HashMap<String, String>();
                messageValues.put("job", this.jobManager.titleize(jobName));
                ((Player)user.getPlayer().get()).sendMessage(this.messageManager.getMessage("command.job.set", messageValues));
            }
            if (!(src instanceof User) || !((User)src).getUniqueId().equals(user.getUniqueId())) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Job set."}));
            }
            return CommandResult.success();
        }
    }
}

