/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.jobs;

import com.erigitic.jobs.TEActionReward;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import org.slf4j.Logger;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.trait.BlockTrait;

public class TEAction {
    private String action;
    private String targetId;
    private String growthTrait = null;
    private String idTrait = null;
    private Map<String, TEActionReward> rewards = new HashMap<String, TEActionReward>();
    private TEActionReward reward;

    public void loadConfigNode(String action, ConfigurationNode node) {
        ConfigurationNode idTraitNode = node.getNode(new Object[]{"id-trait"});
        ConfigurationNode growthTraitNode = node.getNode(new Object[]{"growth-trait"});
        if (idTraitNode.isVirtual()) {
            this.action = action;
            this.targetId = node.getKey().toString();
            this.reward = new TEActionReward();
            this.reward.loadConfigNode(node);
            this.growthTrait = growthTraitNode.getString(null);
            return;
        }
        String traitName = idTraitNode.getString("type");
        ConfigurationNode idTraits = node.getNode(new Object[]{traitName});
        this.rewards.clear();
        if (idTraits.hasMapChildren()) {
            idTraits.getChildrenMap().forEach((k, v) -> {
                if (!(k instanceof String)) {
                    return;
                }
                TEActionReward reward = new TEActionReward();
                reward.loadConfigNode((ConfigurationNode)v);
                this.rewards.put((String)k, reward);
            });
        }
        this.action = action;
        this.targetId = node.getKey().toString();
        this.idTrait = idTraitNode.getString("type");
        this.growthTrait = growthTraitNode.getString(null);
    }

    public Optional<TEActionReward> evaluateBreak(Logger logger, BlockState state, UUID blockCreator) {
        Optional traitVal;
        Optional trait;
        if (!state.getType().getId().equals(this.targetId)) {
            return Optional.empty();
        }
        if (this.growthTrait == null && blockCreator != null) {
            return Optional.empty();
        }
        TEActionReward reward = null;
        if (this.idTrait != null) {
            trait = state.getTrait(this.idTrait);
            if (trait.isPresent()) {
                traitVal = state.getTraitValue((BlockTrait)trait.get());
                if (traitVal.isPresent()) {
                    String key = traitVal.get().toString();
                    reward = this.rewards.getOrDefault(key, null);
                }
            } else {
                logger.warn("ID trait \"" + this.idTrait + "\" not found during action: " + this.action + ':' + this.targetId);
            }
        } else {
            reward = this.reward;
        }
        if (reward == null) {
            return Optional.empty();
        }
        if (this.growthTrait != null) {
            trait = state.getTrait(this.growthTrait);
            if (trait.isPresent()) {
                if (Integer.class.isAssignableFrom(((BlockTrait)trait.get()).getValueClass())) {
                    traitVal = state.getTraitValue((BlockTrait)trait.get());
                    if (traitVal.isPresent()) {
                        reward = this.generateReward((Integer)traitVal.get(), ((BlockTrait)trait.get()).getPossibleValues());
                    } else {
                        logger.warn("Growth trait \"" + this.growthTrait + "\" has missing value during action: " + this.action + ':' + this.targetId);
                    }
                } else {
                    logger.warn("Growth trait \"" + this.growthTrait + "\" is not numeric!");
                }
            } else {
                logger.warn("Growth trait \"" + this.growthTrait + "\" not found during action: " + this.action + ':' + this.targetId);
            }
        }
        return Optional.ofNullable(reward);
    }

    private TEActionReward generateReward(Integer traitValue, Collection<Integer> possibleValues) {
        int max = possibleValues.stream().max(Comparator.comparingInt(Integer::intValue)).orElse(0);
        int min = possibleValues.stream().min(Comparator.comparingInt(Integer::intValue)).orElse(0);
        double percent = (double)(traitValue - min) / (double)(max - min);
        this.reward = new TEActionReward();
        this.reward.setValues((int)((double)this.reward.getExpReward().intValue() * percent), this.reward.getMoneyReward() * percent, this.reward.getCurrencyId());
        return this.reward;
    }

    public Optional<TEActionReward> evaluatePlace(Logger logger, BlockState state) {
        if (!state.getType().getId().equals(this.targetId)) {
            return Optional.empty();
        }
        TEActionReward reward = null;
        if (this.idTrait != null) {
            Optional trait = state.getTrait(this.idTrait);
            if (trait.isPresent()) {
                Optional traitVal = state.getTraitValue((BlockTrait)trait.get());
                if (traitVal.isPresent()) {
                    String key = traitVal.get().toString();
                    reward = this.rewards.getOrDefault(key, null);
                }
            } else {
                logger.warn("ID trait \"" + this.idTrait + "\" not found during action: " + this.action + ':' + this.targetId);
            }
        } else {
            reward = this.reward;
        }
        return Optional.ofNullable(reward);
    }

    public boolean isValid() {
        return this.action != null && !this.action.trim().isEmpty() && this.targetId != null && !this.targetId.trim().isEmpty();
    }

    public boolean isGrowing() {
        return this.growthTrait != null;
    }

    public boolean isIdTraited() {
        return this.idTrait != null;
    }

    public String getIdTrait() {
        return this.idTrait;
    }

    public String getAction() {
        return this.action;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Optional<TEActionReward> getReward() {
        return Optional.ofNullable(this.reward);
    }

    public Map<String, TEActionReward> getRewards() {
        return this.rewards;
    }
}

