/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.jobs;

import com.erigitic.jobs.JobBasedRequirement;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class TEJob {
    private String name;
    private BigDecimal salary;
    private List<String> sets = new ArrayList<String>();
    private JobBasedRequirement requirement;
    private boolean isValid;

    public TEJob(ConfigurationNode node) {
        this.name = node.getKey().toString();
        this.salary = new BigDecimal(node.getNode(new Object[]{"salary"}).getString());
        try {
            this.sets = node.getNode(new Object[]{"sets"}).getList(TypeToken.of(String.class), new ArrayList());
            ConfigurationNode req = node.getNode(new Object[]{"require"});
            if (!req.isVirtual()) {
                String job = req.getNode(new Object[]{"job"}).getString(null);
                int level = req.getNode(new Object[]{"level"}).getInt(0);
                String permission = req.getNode(new Object[]{"permission"}).getString(null);
                if (job != null && job.trim().isEmpty()) {
                    job = null;
                }
                this.requirement = new JobBasedRequirement(job, level, permission);
            }
            this.isValid = true;
        }
        catch (ObjectMappingException e) {
            this.isValid = false;
            e.printStackTrace();
        }
    }

    public List<String> getSets() {
        return this.sets;
    }

    public boolean salaryEnabled() {
        return !this.salary.equals(BigDecimal.ZERO);
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getSalary() {
        return this.salary;
    }

    public Optional<JobBasedRequirement> getRequirement() {
        return Optional.ofNullable(this.requirement);
    }

    public boolean isValid() {
        return this.isValid;
    }
}

