/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items.urantypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.util.Registry;

public class Thorium232
extends UranBaseType {
    public Thorium232() {
        this.loadDefaults();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(IUranium.RodType type) {
        return Ic2Icons.getTextures((String)"ic2c_extras_nuclear_cells")[this.getRodID(type) - 1100];
    }

    public int getRow() {
        return 0;
    }

    public int getMaxDurability() {
        return 15000;
    }

    public float getEUPerPulse() {
        return 0.6f;
    }

    public int getPulsesPerTick() {
        return 1;
    }

    public int getPulsesForConnection() {
        return 1;
    }

    public float getHeatModifier() {
        return 1.0f;
    }

    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    public ItemStack getUraniumIngot() {
        return new ItemStack((Item)Registry.thorium232Ingot);
    }

    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return new ItemStack((Item)Registry.singleThorium232Cell).func_77946_l();
            }
            case DualRod: {
                return new ItemStack((Item)Registry.doubleThorium232Cell).func_77946_l();
            }
            case QuadRod: {
                return new ItemStack((Item)Registry.quadThorium232Cell).func_77946_l();
            }
            case NearDepletedRod: {
                return new ItemStack((Item)Registry.nearDepletedThorium232Cell).func_77946_l();
            }
            case IsotopicRod: {
                return new ItemStack((Item)Registry.isotopicThorium232Cell).func_77946_l();
            }
            case ReEnrichedRod: {
                return new ItemStack((Item)Registry.reEnrichedThorium232Cell).func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage((ItemStack)this.getRodType(IUranium.RodType.IsotopicRod), (int)(this.getMaxDurability() - 1));
    }

    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 1115;
            }
            case DualRod: {
                return 1109;
            }
            case QuadRod: {
                return 1103;
            }
            case ReEnrichedRod: {
                return 1133;
            }
            case NearDepletedRod: {
                return 1121;
            }
            case IsotopicRod: {
                return 1127;
            }
        }
        return 0;
    }

    public LocaleComp getName(IUranium.RodType rodType) {
        return Ic2Lang.nullKey;
    }

    public boolean isReEnrichedUran() {
        return false;
    }

    public Color getReEnrichedColor() {
        return null;
    }

    public ItemStack getIngridient() {
        return null;
    }

    public int getIngrientPoints() {
        return 0;
    }

    public int getIngridientCost() {
        return 0;
    }
}

