/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuCraftingPriority
extends ComponentMenu {
    private static final String NBT_SELECTED = "SelectedOption";
    private static final int RADIO_MARGIN = 13;
    private static final int RADIO_X = 5;
    private static final int RADIO_Y = 5;
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            DataWriter dw = ComponentMenuCraftingPriority.this.getWriterForServerComponentPacket();
            dw.writeBoolean(selectedOption == 0);
            PacketHandler.sendDataToServer(dw);
        }
    };

    public ComponentMenuCraftingPriority(FlowComponent parent) {
        super(parent);
        this.radioButtons.add(new RadioButton(5, 5, Localization.PRIORITY_MOVE_FIRST));
        this.radioButtons.add(new RadioButton(5, 18, Localization.PRIORITY_CRAFT_FIRST));
    }

    @Override
    public String getName() {
        return "Priority";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.radioButtons.getSelectedOption() == 0);
    }

    @Override
    public void readData(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readBoolean() ? 0 : 1);
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.radioButtons.setSelectedOption(((ComponentMenuCraftingPriority)menu).radioButtons.getSelectedOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuCraftingPriority newDataPriority = (ComponentMenuCraftingPriority)newData;
        if (this.radioButtons.getSelectedOption() != newDataPriority.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataPriority.radioButtons.getSelectedOption());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(this.radioButtons.getSelectedOption() == 0);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_SELECTED));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_SELECTED, (byte)this.radioButtons.getSelectedOption());
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readBoolean() ? 0 : 1);
    }

    public boolean shouldPrioritizeCrafting() {
        return this.radioButtons.getSelectedOption() == 1;
    }

    public void setPrioritizeCrafting(boolean val) {
        this.radioButtons.setSelectedOption(val ? 1 : 0);
    }
}

