/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.api.block.ICarvable;
import team.chisel.api.chunkdata.IOffsetData;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.util.NBTSaveable;
import team.chisel.common.util.PerChunkData;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;

@ParametersAreNonnullByDefault
public class ItemOffsetTool
extends Item {
    public static final String DATA_KEY = "offsettool";

    public ItemOffsetTool() {
        this.func_77637_a(ChiselTabs.tab);
        this.func_77655_b("chisel.offsettool");
        this.setRegistryName(DATA_KEY);
        this.func_77664_n();
        PerChunkData.INSTANCE.registerChunkData(DATA_KEY, new PerChunkData.ChunkDataBase<OffsetData>(OffsetData.class, true));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ICarvable) {
            if (world.field_72995_K) {
                return this.canOffset(player, world, pos, hand, facing) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            PerChunkData.ChunkDataBase cd = (PerChunkData.ChunkDataBase)PerChunkData.INSTANCE.getData(DATA_KEY);
            OffsetData data = (OffsetData)cd.getDataForChunk(world.field_73011_w.getDimension(), world.func_175726_f(pos).func_76632_l());
            data.move(this.getMoveDir(facing, hitX, hitY, hitZ));
            PerChunkData.INSTANCE.chunkModified(world.func_175726_f(pos), DATA_KEY);
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public EnumFacing getMoveDir(EnumFacing face, double xCoord, double yCoord, double zCoord) {
        HashMap map = Maps.newHashMap();
        if (face.func_82601_c() != 0) {
            this.fillMap(map, zCoord, yCoord, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH);
        } else if (face.func_96559_d() != 0) {
            this.fillMap(map, xCoord, zCoord, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST);
        } else if (face.func_82599_e() != 0) {
            this.fillMap(map, xCoord, yCoord, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST);
        }
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort(keys);
        return (EnumFacing)map.get(keys.get(0));
    }

    private void fillMap(Map<Double, EnumFacing> map, double x, double y, EnumFacing ... dirs) {
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 1.0, 0.0, x, y), dirs[0]);
        map.put(Line2D.ptLineDistSq(0.0, 1.0, 1.0, 1.0, x, y), dirs[1]);
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 0.0, 1.0, x, y), dirs[2]);
        map.put(Line2D.ptLineDistSq(1.0, 0.0, 1.0, 1.0, x, y), dirs[3]);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        RayTraceResult mop = event.getTarget();
        EntityPlayer player = event.getPlayer();
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK && (this.canOffset(player, player.field_70170_p, mop.func_178782_a(), EnumHand.MAIN_HAND, mop.field_178784_b) || this.canOffset(player, player.field_70170_p, mop.func_178782_a(), EnumHand.OFF_HAND, mop.field_178784_b))) {
            boolean isZ;
            EnumFacing face = mop.field_178784_b;
            BlockPos pos = mop.func_178782_a();
            BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            buf.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            double px = -(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks());
            double py = -(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks());
            double pz = -(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks());
            double x = (double)Math.max(0, face.func_82601_c()) + 0.01 * (double)face.func_82601_c();
            double y = (double)Math.max(0, face.func_96559_d()) + 0.01 * (double)face.func_96559_d();
            double z = (double)Math.max(0, face.func_82599_e()) + 0.01 * (double)face.func_82599_e();
            GlStateManager.func_179137_b((double)px, (double)py, (double)pz);
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
            if (face.func_82601_c() != 0) {
                buf.func_181662_b(x, 0.0, 0.0).func_181675_d();
                buf.func_181662_b(x, 1.0, 1.0).func_181675_d();
                buf.func_181662_b(x, 1.0, 0.0).func_181675_d();
                buf.func_181662_b(x, 0.0, 1.0).func_181675_d();
            } else if (face.func_96559_d() != 0) {
                buf.func_181662_b(0.0, y, 0.0).func_181675_d();
                buf.func_181662_b(1.0, y, 1.0).func_181675_d();
                buf.func_181662_b(1.0, y, 0.0).func_181675_d();
                buf.func_181662_b(0.0, y, 1.0).func_181675_d();
            } else {
                buf.func_181662_b(0.0, 0.0, z).func_181675_d();
                buf.func_181662_b(1.0, 1.0, z).func_181675_d();
                buf.func_181662_b(1.0, 0.0, z).func_181675_d();
                buf.func_181662_b(0.0, 1.0, z).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            Vec3d hit = mop.field_72307_f;
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179129_p();
            buf.func_181668_a(4, DefaultVertexFormats.field_181705_e);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.33333334f);
            EnumFacing moveDir = this.getMoveDir(face, hit.field_72450_a - (double)pos.func_177958_n(), hit.field_72448_b - (double)pos.func_177956_o(), hit.field_72449_c - (double)pos.func_177952_p());
            int clampedX = Math.max(0, moveDir.func_82601_c());
            int clampedY = Math.max(0, moveDir.func_96559_d());
            int clampedZ = Math.max(0, moveDir.func_82599_e());
            boolean isX = moveDir.func_82601_c() != 0;
            boolean isY = moveDir.func_96559_d() != 0;
            boolean bl = isZ = moveDir.func_82599_e() != 0;
            if (face.func_82601_c() != 0) {
                buf.func_181662_b(x, 0.5, 0.5).func_181675_d();
                buf.func_181662_b(x, isY ? (double)clampedY : 0.0, isZ ? (double)clampedZ : 0.0).func_181675_d();
                buf.func_181662_b(x, isY ? (double)clampedY : 1.0, isZ ? (double)clampedZ : 1.0).func_181675_d();
            } else if (face.func_96559_d() != 0) {
                buf.func_181662_b(0.5, y, 0.5).func_181675_d();
                buf.func_181662_b(isX ? (double)clampedX : 0.0, y, isZ ? (double)clampedZ : 0.0).func_181675_d();
                buf.func_181662_b(isX ? (double)clampedX : 1.0, y, isZ ? (double)clampedZ : 1.0).func_181675_d();
            } else {
                buf.func_181662_b(0.5, 0.5, z).func_181675_d();
                buf.func_181662_b(isX ? (double)clampedX : 0.0, isY ? (double)clampedY : 0.0, z).func_181675_d();
                buf.func_181662_b(isX ? (double)clampedX : 1.0, isY ? (double)clampedY : 1.0, z).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    private boolean canOffset(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (player.func_184586_b(hand).func_190926_b() || player.func_184586_b(hand).func_77973_b() != this) {
            return false;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        return model instanceof AbstractCTMBakedModel;
    }

    public static class OffsetData
    implements NBTSaveable,
    IOffsetData {
        private BlockPos offset = BlockPos.field_177992_a;

        @Override
        public void write(NBTTagCompound tag) {
            tag.func_74777_a("offset", (short)(this.offset.func_177958_n() << 8 | this.offset.func_177956_o() << 4 | this.offset.func_177952_p()));
        }

        @Override
        public void read(NBTTagCompound tag) {
            short data = tag.func_74765_d("offset");
            this.offset = new BlockPos(data >> 8 & 0xF, data >> 4 & 0xF, data & 0xF);
        }

        void move(EnumFacing dir) {
            this.offset = this.wrap(this.offset.func_177972_a(dir.func_176734_d()));
        }

        @Override
        @Nonnull
        public BlockPos getOffset() {
            return this.offset;
        }

        private int positiveModulo(int num, int denom) {
            return (num + denom) % denom;
        }

        private BlockPos wrap(BlockPos pos) {
            return new BlockPos(this.positiveModulo(pos.func_177958_n(), 16), this.positiveModulo(pos.func_177956_o(), 16), this.positiveModulo(pos.func_177952_p(), 16));
        }

        public String toString() {
            return "ItemOffsetTool.OffsetData(offset=" + this.getOffset() + ")";
        }
    }
}

