/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.caching;

import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FactionsCache {
    private static final Map<String, Faction> factionsCacheMap = new HashMap<String, Faction>();
    private static final Set<Claim> claimsCacheSet = new HashSet<Claim>();

    private FactionsCache() {
    }

    public static Map<String, Faction> getFactionsMap() {
        return factionsCacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdateFactionCache(Faction faction) {
        Map<String, Faction> map = factionsCacheMap;
        synchronized (map) {
            Faction factionToUpdate = factionsCacheMap.get(faction.getName().toLowerCase());
            if (factionToUpdate != null) {
                factionsCacheMap.replace(factionToUpdate.getName().toLowerCase(), faction);
                claimsCacheSet.removeAll(factionToUpdate.getClaims());
            } else {
                factionsCacheMap.put(faction.getName().toLowerCase(), faction);
            }
            if (!faction.getClaims().isEmpty()) {
                claimsCacheSet.addAll(faction.getClaims());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFactionCache(String factionName) {
        Map<String, Faction> map = factionsCacheMap;
        synchronized (map) {
            Faction faction = factionsCacheMap.remove(factionName.toLowerCase());
            claimsCacheSet.removeAll(faction.getClaims());
        }
    }

    @Nullable
    public static Faction getFactionCache(String factionName) {
        Faction optionalFaction = factionsCacheMap.get(factionName.toLowerCase());
        if (optionalFaction != null) {
            return optionalFaction;
        }
        return null;
    }

    public static Set<Claim> getAllClaims() {
        return claimsCacheSet;
    }

    public static void removeClaimCache(Claim claim) {
        claimsCacheSet.remove(claim);
    }

    public static void clearCache() {
        claimsCacheSet.clear();
        factionsCacheMap.clear();
    }
}

