/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class PlayerCommand
extends AbstractCommand {
    public PlayerCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalPlayer = context.getOne("player");
        if (optionalPlayer.isPresent()) {
            Player player = (Player)optionalPlayer.get();
            this.showPlayerInfo(source, player);
        } else if (source instanceof Player) {
            Player player = (Player)source;
            this.showPlayerInfo(source, player);
        }
        return CommandResult.success();
    }

    private void showPlayerInfo(CommandSource source, Player player) {
        ArrayList<Text> playerInfo = new ArrayList<Text>();
        String playerFactionName = "";
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (optionalPlayerFaction.isPresent()) {
            playerFactionName = optionalPlayerFaction.get().getName();
        }
        Date lastPlayed = Date.from((Instant)player.getJoinData().lastPlayed().get());
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String formattedDate = formatter.format(lastPlayed);
        Text info = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.NAME + ": ", TextColors.GOLD, this.getPlugin().getPlayerManager().getPlayerName(player.getUniqueId()).get() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.LAST_PLAYED + ": ", TextColors.GOLD, formattedDate + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.FACTION + ": ", TextColors.GOLD, playerFactionName + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.POWER + ": ", TextColors.GOLD, this.getPlugin().getPowerManager().getPlayerPower(player.getUniqueId()) + "/" + this.getPlugin().getPowerManager().getPlayerMaxPower(player.getUniqueId())})}).build();
        playerInfo.add(info);
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.PLAYER_INFO})).padding((Text)Text.of((String)"=")).contents(playerInfo);
        paginationBuilder.sendTo((MessageReceiver)source);
    }
}

