/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class TopCommand
extends AbstractCommand {
    public TopCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        ArrayList<Faction> factionsList = new ArrayList<Faction>(this.getPlugin().getFactionLogic().getFactions().values());
        ArrayList<Text> helpList = new ArrayList<Text>();
        int index = 0;
        Text tagPrefix = this.getPlugin().getConfiguration().getChatConfig().getFactionStartPrefix();
        Text tagSuffix = this.getPlugin().getConfiguration().getChatConfig().getFactionEndPrefix();
        factionsList.sort((o1, o2) -> {
            float firstFactionPower = super.getPlugin().getPowerManager().getFactionPower((Faction)o1);
            float secondFactionPower = super.getPlugin().getPowerManager().getFactionPower((Faction)o2);
            return Float.compare(secondFactionPower, firstFactionPower);
        });
        for (Faction faction : factionsList) {
            if (faction.isSafeZone() || faction.isWarZone()) continue;
            if (index == 11) break;
            ++index;
            Text tag = Text.builder().append(new Text[]{tagPrefix}).append(new Text[]{faction.getTag()}).append(new Text[]{tagSuffix, Text.of((String)" ")}).build();
            Text factionHelp = Text.builder().append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "- "})}).append(new Text[]{tag}).append(new Text[]{Text.of((Object[])new Object[]{faction.getName(), " (", Float.valueOf(this.getPlugin().getPowerManager().getFactionPower(faction)), "/", Float.valueOf(this.getPlugin().getPowerManager().getFactionMaxPower(faction)), ")"})}).build()}).build();
            helpList.add(factionHelp);
        }
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.FACTIONS_LIST})).padding((Text)Text.of((String)"-")).contents(helpList);
        paginationBuilder.sendTo((MessageReceiver)source);
        return CommandResult.success();
    }
}

