/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class UnclaimCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public UnclaimCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Location homeLocation;
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (super.getPlugin().getPlayerManager().hasAdminMode((User)player)) {
            World world = player.getWorld();
            Vector3i chunk = player.getLocation().getChunkPosition();
            Optional<Faction> optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), chunk);
            if (optionalChunkFaction.isPresent()) {
                Location homeLocation2;
                boolean isCancelled = EventRunner.runFactionUnclaimEvent(player, optionalChunkFaction.get(), world, chunk);
                if (isCancelled) {
                    return CommandResult.success();
                }
                if (!this.factionsConfig.canPlaceHomeOutsideFactionClaim() && optionalChunkFaction.get().getHome() != null && world.getUniqueId().equals(optionalChunkFaction.get().getHome().getWorldUUID()) && (homeLocation2 = world.getLocation(optionalChunkFaction.get().getHome().getBlockPosition())).getChunkPosition().toString().equals(player.getLocation().getChunkPosition().toString())) {
                    super.getPlugin().getFactionLogic().setHome(optionalChunkFaction.get(), null);
                }
                super.getPlugin().getFactionLogic().removeClaim(optionalChunkFaction.get(), new Claim(world.getUniqueId(), chunk));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.LAND_HAS_BEEN_SUCCESSFULLY_UNCLAIMED}));
                return CommandResult.success();
            }
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLACE_DOES_NOT_BELOG_TO_ANYONE}));
            return CommandResult.success();
        }
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (!this.getPlugin().getPermsManager().canClaim(player.getUniqueId(), playerFaction)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.PLAYERS_WITH_YOUR_RANK_CANT_UNCLAIM_LANDS}));
        }
        World world = player.getWorld();
        Vector3i chunk = player.getLocation().getChunkPosition();
        Optional<Faction> optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), chunk);
        if (!optionalChunkFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLACE_DOES_NOT_BELOG_TO_ANYONE}));
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (!chunkFaction.getName().equals(playerFaction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, Messages.THIS_LAND_BELONGS_TO_SOMEONE_ELSE}));
        }
        boolean isCancelled = EventRunner.runFactionUnclaimEvent(player, chunkFaction, world, chunk);
        if (isCancelled) {
            return CommandResult.success();
        }
        if (!this.factionsConfig.canPlaceHomeOutsideFactionClaim() && optionalChunkFaction.get().getHome() != null && world.getUniqueId().equals(optionalChunkFaction.get().getHome().getWorldUUID()) && (homeLocation = world.getLocation(optionalChunkFaction.get().getHome().getBlockPosition())).getChunkPosition().equals((Object)chunk)) {
            super.getPlugin().getFactionLogic().setHome(optionalChunkFaction.get(), null);
        }
        Faction faction = super.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), chunk).get();
        super.getPlugin().getFactionLogic().removeClaim(faction, new Claim(world.getUniqueId(), chunk));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.LAND_HAS_BEEN_SUCCESSFULLY_UNCLAIMED}));
        return CommandResult.success();
    }
}

