/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.events;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.events.FactionAreaEnterEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionChestEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionClaimEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionCreateEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionJoinEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionKickEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionLeaveEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionUnclaimEventImpl;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.world.World;

public final class EventRunner {
    public static boolean runFactionLeaveEvent(Player player, Faction faction) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionLeaveEventImpl event = new FactionLeaveEventImpl(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionJoinEvent(Player player, Faction faction) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionJoinEventImpl event = new FactionJoinEventImpl(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionChestEvent(Player player, Faction faction) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionChestEventImpl event = new FactionChestEventImpl(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionClaimEvent(Player player, Faction faction, World world, Vector3i chunkPosition) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionClaimEventImpl event = new FactionClaimEventImpl(player, faction, world, chunkPosition, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionCreateEvent(Player player, Faction faction) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionCreateEventImpl event = new FactionCreateEventImpl(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionKickEvent(FactionPlayer kickedPlayer, Player kickedBy, Faction faction) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)kickedBy).add(EventContextKeys.PLAYER, (Object)kickedBy).add(EventContextKeys.CREATOR, (Object)kickedBy).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)kickedBy, (Object[])new Object[]{faction});
        FactionKickEventImpl event = new FactionKickEventImpl(kickedPlayer, kickedBy, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionUnclaimEvent(Player player, Faction faction, World world, Vector3i chunkPosition) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionUnclaimEventImpl event = new FactionUnclaimEventImpl(player, faction, world, chunkPosition, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionAreaEnterEvent(MoveEntityEvent moveEntityEvent, Player player, Optional<Faction> enteredFaction, Optional<Faction> leftFaction) {
        EventContext eventContext = EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{enteredFaction, leftFaction});
        FactionAreaEnterEventImpl event = new FactionAreaEnterEventImpl(moveEntityEvent, player, enteredFaction, leftFaction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }
}

