/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.PVPLogger;
import io.github.aquerr.eaglefactions.api.managers.ProtectionManager;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.IgniteEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class EntityDamageListener
extends AbstractListener {
    private final PVPLogger pvpLogger;
    private final ProtectionConfig protectionConfig;
    private final FactionsConfig factionsConfig;
    private final PowerConfig powerConfig;
    private final ProtectionManager protectionManager;

    public EntityDamageListener(EagleFactions plugin) {
        super(plugin);
        this.pvpLogger = plugin.getPVPLogger();
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.powerConfig = plugin.getConfiguration().getPowerConfig();
        this.protectionManager = plugin.getProtectionManager();
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onEntityDamage(DamageEntityEvent event) {
        IndirectEntityDamageSource indirectEntityDamageSource;
        Entity sourceEntity;
        Entity targetEntity = event.getTargetEntity();
        Cause cause = event.getCause();
        if (targetEntity instanceof Player) {
            return;
        }
        if (targetEntity instanceof Living && !(targetEntity instanceof ArmorStand)) {
            return;
        }
        Player user = null;
        if (cause.root() instanceof IndirectEntityDamageSource && (sourceEntity = (indirectEntityDamageSource = (IndirectEntityDamageSource)cause.root()).getIndirectSource()) instanceof Player) {
            user = (Player)sourceEntity;
        }
        if (user == null) {
            return;
        }
        if (!super.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)targetEntity.getLocation(), (User)user, true)) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY, beforeModifications=true)
    public void onPlayerDamage(DamageEntityEvent event, @Getter(value="getTargetEntity") Player attackedPlayer) {
        if (!(event.getCause().root() instanceof DamageSource)) {
            return;
        }
        World world = attackedPlayer.getWorld();
        boolean willCauseDeath = event.willCauseDeath();
        Object rootCause = event.getCause().root();
        DoubleUnaryOperator doubleUnaryOperator = operand -> {
            double difference = operand * (double)(this.factionsConfig.getPercentageDamageReductionInOwnTerritory() / 100.0f);
            return -difference;
        };
        DamageModifier damageReductionModifier = DamageModifier.builder().type(DamageModifierTypes.ARMOR).cause(Cause.builder().append((Object)super.getPlugin()).build(EventContext.builder().build())).build();
        if (rootCause instanceof IndirectEntityDamageSource) {
            IndirectEntityDamageSource indirectEntityDamageSource = (IndirectEntityDamageSource)rootCause;
            Entity indirectSource = indirectEntityDamageSource.getIndirectSource();
            if (indirectSource instanceof Player) {
                boolean shouldBlockDamage = this.shouldBlockDamageFromPlayer(attackedPlayer, (Player)indirectSource, willCauseDeath);
                if (shouldBlockDamage) {
                    event.setBaseDamage(0.0);
                    event.setCancelled(true);
                    if (!(indirectEntityDamageSource.getSource() instanceof Player)) {
                        indirectEntityDamageSource.getSource().remove();
                    }
                    world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.SMOKE).quantity(50).offset(new Vector3d(0.5, 1.5, 0.5)).build(), attackedPlayer.getPosition());
                } else {
                    this.pvpLogger.addOrUpdatePlayer(attackedPlayer);
                    if (this.isInOwnTerritory(attackedPlayer)) {
                        event.addModifierAfter(damageReductionModifier, doubleUnaryOperator, new HashSet());
                    }
                }
            }
        } else if (rootCause instanceof EntityDamageSource) {
            EntityDamageSource entityDamageSource = (EntityDamageSource)rootCause;
            Entity entitySource = entityDamageSource.getSource();
            if (entityDamageSource.getClass().getName().contains("techguns")) {
                try {
                    Object attacker = entityDamageSource.getClass().getField("attacker").get(entityDamageSource);
                    if (attacker instanceof Player) {
                        entitySource = (Player)attacker;
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            if (entitySource instanceof Player) {
                Player player = (Player)entitySource;
                boolean shouldBlockDamage = this.shouldBlockDamageFromPlayer(attackedPlayer, player, willCauseDeath);
                if (shouldBlockDamage) {
                    event.setBaseDamage(0.0);
                    event.setCancelled(true);
                    world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.SMOKE).quantity(50).offset(new Vector3d(0.5, 1.5, 0.5)).build(), attackedPlayer.getPosition());
                } else {
                    this.pvpLogger.addOrUpdatePlayer(attackedPlayer);
                    if (this.isInOwnTerritory(attackedPlayer)) {
                        event.addModifierAfter(damageReductionModifier, doubleUnaryOperator, new HashSet());
                    }
                }
            } else {
                Optional<Faction> optionalAttackedChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(attackedPlayer.getWorld().getUniqueId(), attackedPlayer.getLocation().getChunkPosition());
                if (this.protectionConfig.getSafeZoneWorldNames().contains(attackedPlayer.getWorld().getName())) {
                    event.setCancelled(true);
                    return;
                }
                if (optionalAttackedChunkFaction.isPresent() && optionalAttackedChunkFaction.get().isSafeZone()) {
                    event.setCancelled(true);
                    return;
                }
                if (this.isInOwnTerritory(attackedPlayer)) {
                    event.addModifierAfter(damageReductionModifier, doubleUnaryOperator, new HashSet());
                }
            }
        }
    }

    private boolean shouldBlockDamageFromPlayer(Player attackedPlayer, Player sourcePlayer, boolean willCauseDeath) {
        boolean canAttack = this.protectionManager.canAttackEntity((Entity)attackedPlayer, sourcePlayer, false);
        if (!canAttack) {
            return true;
        }
        if (!willCauseDeath) {
            return false;
        }
        Optional<Faction> attackedPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(attackedPlayer.getUniqueId());
        Optional<Faction> sourcePlayerFFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(sourcePlayer.getUniqueId());
        if (attackedPlayerFaction.isPresent() && sourcePlayerFFaction.isPresent()) {
            Faction sourceFaction;
            Faction attackedFaction = attackedPlayerFaction.get();
            if (attackedFaction.equals(sourceFaction = sourcePlayerFFaction.get())) {
                this.sendPenaltyMessageAndDecreasePower(sourcePlayer);
            } else if (attackedFaction.isTruce(sourceFaction)) {
                this.sendPenaltyMessageAndDecreasePower(sourcePlayer);
            } else if (attackedFaction.isAlly(sourceFaction)) {
                this.sendPenaltyMessageAndDecreasePower(sourcePlayer);
            } else {
                this.sendKillAwardMessageAndIncreasePower(sourcePlayer);
            }
        } else {
            this.sendKillAwardMessageAndIncreasePower(sourcePlayer);
        }
        return false;
    }

    @Listener
    public void onIgniteEntity(IgniteEntityEvent event) {
        EventContext eventContext = event.getContext();
        Entity entity = event.getTargetEntity();
        World world = event.getTargetEntity().getWorld();
        if (!(entity instanceof Player)) {
            return;
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            event.setCancelled(true);
            return;
        }
        Player ignitedPlayer = (Player)entity;
        Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), ignitedPlayer.getLocation().getChunkPosition());
        if (optionalChunkFaction.isPresent() && optionalChunkFaction.get().isSafeZone()) {
            event.setCancelled(true);
            return;
        }
        if (!eventContext.containsKey(EventContextKeys.OWNER) || !(eventContext.get(EventContextKeys.OWNER).get() instanceof Player)) {
            return;
        }
        Player igniterPlayer = (Player)eventContext.get(EventContextKeys.OWNER).get();
        boolean isFactionFriendlyFireOn = this.factionsConfig.isFactionFriendlyFire();
        boolean isAllianceFriendlyFireOn = this.factionsConfig.isAllianceFriendlyFire();
        boolean isTruceFriendlyFireOn = this.factionsConfig.isTruceFriendlyFire();
        if (isFactionFriendlyFireOn && isAllianceFriendlyFireOn && isTruceFriendlyFireOn) {
            return;
        }
        Optional<Faction> optionalIgnitedPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(ignitedPlayer.getUniqueId());
        Optional<Faction> optionalIgniterPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(igniterPlayer.getUniqueId());
        if (optionalIgnitedPlayerFaction.isPresent() && optionalIgniterPlayerFaction.isPresent()) {
            Faction ignitedPlayerFaction = optionalIgnitedPlayerFaction.get();
            Faction igniterPlayerFaction = optionalIgniterPlayerFaction.get();
            if (!isFactionFriendlyFireOn && ignitedPlayerFaction.getName().equals(igniterPlayerFaction.getName())) {
                event.setCancelled(true);
                return;
            }
            if (!isTruceFriendlyFireOn && ignitedPlayerFaction.getTruces().contains(igniterPlayerFaction.getName())) {
                event.setCancelled(true);
                return;
            }
            if (!isAllianceFriendlyFireOn && ignitedPlayerFaction.getAlliances().contains(igniterPlayerFaction.getName())) {
                event.setCancelled(true);
                return;
            }
        }
    }

    private void sendPenaltyMessageAndDecreasePower(Player player) {
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOUR_POWER_HAS_BEEN_DECREASED_BY, ImmutableMap.of((Object)Placeholders.NUMBER, (Object)Float.valueOf(this.powerConfig.getPenalty()))) + "\n", TextColors.GRAY, Messages.CURRENT_POWER + " ", super.getPlugin().getPowerManager().getPlayerPower(player.getUniqueId()) + "/" + this.getPlugin().getPowerManager().getPlayerMaxPower(player.getUniqueId())}));
        super.getPlugin().getPowerManager().penalty(player.getUniqueId());
    }

    private void sendKillAwardMessageAndIncreasePower(Player player) {
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOUR_POWER_HAS_BEEN_INCREASED_BY, ImmutableMap.of((Object)Placeholders.NUMBER, (Object)Float.valueOf(this.powerConfig.getKillAward()))) + "\n", TextColors.GRAY, Messages.CURRENT_POWER + " ", super.getPlugin().getPowerManager().getPlayerPower(player.getUniqueId()) + "/" + this.getPlugin().getPowerManager().getPlayerMaxPower(player.getUniqueId())}));
        super.getPlugin().getPowerManager().addPower(player.getUniqueId(), true);
    }

    private boolean isInOwnTerritory(Player player) {
        Optional<Faction> optionalFaction = super.getPlugin().getFactionLogic().getFactionByChunk(player.getWorld().getUniqueId(), player.getLocation().getChunkPosition());
        return optionalFaction.filter(x -> x.getPlayerMemberType(player.getUniqueId()) != null).isPresent();
    }
}

