/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.StorageConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.storage.IFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.IPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.HOCONFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.HOCONPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2FactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.utils.DeleteFactionTask;
import io.github.aquerr.eaglefactions.common.storage.utils.IStorageTask;
import io.github.aquerr.eaglefactions.common.storage.utils.UpdateFactionTask;
import java.nio.file.Path;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class StorageManagerImpl
implements StorageManager {
    private final IFactionStorage factionsStorage;
    private final IPlayerStorage playerStorage;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public StorageManagerImpl(EagleFactions plugin, StorageConfig storageConfig, Path configDir) {
        switch (storageConfig.getStorageType().toLowerCase()) {
            case "hocon": {
                this.factionsStorage = new HOCONFactionStorage(configDir);
                this.playerStorage = new HOCONPlayerStorage(configDir);
                plugin.printInfo("HOCON storage has been initialized!");
                break;
            }
            case "h2": {
                this.factionsStorage = new H2FactionStorage(plugin);
                this.playerStorage = new H2PlayerStorage(plugin);
                plugin.printInfo("H2 storage has been initialized!");
                break;
            }
            case "mysql": {
                this.factionsStorage = new MySQLFactionStorage(plugin);
                this.playerStorage = new MySQLPlayerStorage(plugin);
                plugin.printInfo("MySQL storage has been initialized!");
                break;
            }
            case "mariadb": {
                this.factionsStorage = new MariaDbFactionStorage(plugin);
                this.playerStorage = new MariaDbPlayerStorage(plugin);
                plugin.printInfo("MariaDB storage has been initialized!");
                break;
            }
            default: {
                plugin.printInfo("Couldn't find provided storage type.");
                this.factionsStorage = new HOCONFactionStorage(configDir);
                this.playerStorage = new HOCONPlayerStorage(configDir);
                plugin.printInfo("Initialized default HOCON storage.");
            }
        }
        this.prepareFactionsCache();
    }

    private void queueStorageTask(IStorageTask task) {
        this.executorService.execute(task);
    }

    @Override
    public void addOrUpdateFaction(Faction faction) {
        FactionsCache.addOrUpdateFactionCache(faction);
        this.queueStorageTask(new UpdateFactionTask(faction, () -> this.factionsStorage.addOrUpdateFaction(faction)));
    }

    @Override
    public boolean deleteFaction(String factionName) {
        FactionsCache.removeFactionCache(factionName);
        this.queueStorageTask(new DeleteFactionTask(factionName, () -> this.factionsStorage.deleteFaction(factionName)));
        return true;
    }

    @Override
    @Nullable
    public Faction getFaction(String factionName) {
        try {
            Faction factionCache = FactionsCache.getFactionCache(factionName);
            if (factionCache != null) {
                return factionCache;
            }
            Faction faction = this.factionsStorage.getFaction(factionName);
            if (faction == null) {
                return null;
            }
            FactionsCache.addOrUpdateFactionCache(faction);
            return faction;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void prepareFactionsCache() {
        Set<Faction> factionSet = this.factionsStorage.getFactions();
        for (Faction faction : factionSet) {
            FactionsCache.addOrUpdateFactionCache(faction);
        }
    }

    @Override
    public void reloadStorage() {
        FactionsCache.clearCache();
        this.factionsStorage.load();
        this.prepareFactionsCache();
    }

    @Override
    public boolean checkIfPlayerExists(UUID playerUUID, String playerName) {
        return this.playerStorage.checkIfPlayerExists(playerUUID, playerName);
    }

    @Override
    public boolean addPlayer(UUID playerUUID, String playerName, float startingPower, float maxpower) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.addPlayer(playerUUID, playerName, startingPower, maxpower)).isDone();
    }

    @Override
    public boolean setDeathInWarzone(UUID playerUUID, boolean didDieInWarZone) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.setDeathInWarzone(playerUUID, didDieInWarZone)).isDone();
    }

    @Override
    public boolean getLastDeathInWarzone(UUID playerUUID) {
        return this.playerStorage.getLastDeathInWarzone(playerUUID);
    }

    @Override
    public float getPlayerPower(UUID playerUUID) {
        return this.playerStorage.getPlayerPower(playerUUID);
    }

    @Override
    public boolean setPlayerPower(UUID playerUUID, float power) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.setPlayerPower(playerUUID, power)).isDone();
    }

    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        return this.playerStorage.getPlayerMaxPower(playerUUID);
    }

    @Override
    public boolean setPlayerMaxPower(UUID playerUUID, float maxpower) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.setPlayerMaxPower(playerUUID, maxpower)).isDone();
    }

    @Override
    public Set<String> getServerPlayerNames() {
        return this.playerStorage.getServerPlayerNames();
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        return this.playerStorage.getServerPlayers();
    }

    @Override
    public String getPlayerName(UUID playerUUID) {
        return this.playerStorage.getPlayerName(playerUUID);
    }

    @Override
    public boolean updatePlayerName(UUID playerUUID, String playerName) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.updatePlayerName(playerUUID, playerName)).isDone();
    }
}

