/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.common.entities.FactionChestImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionImpl;
import io.github.aquerr.eaglefactions.common.storage.IFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2Provider;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLProvider;
import io.github.aquerr.eaglefactions.common.storage.utils.InventorySerializer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public abstract class AbstractFactionStorage
implements IFactionStorage {
    private static final String SELECT_FACTION_NAMES = "SELECT Name FROM Factions";
    private static final String SELECT_RECRUITS_WHERE_FACTIONNAME = "SELECT RecruitUUID FROM FactionRecruits WHERE FactionName=?";
    private static final String SELECT_OFFICERS_WHERE_FACTIONNAME = "SELECT OfficerUUID FROM FactionOfficers WHERE FactionName=?";
    private static final String SELECT_MEMBERS_WHERE_FACTIONNAME = "SELECT MemberUUID FROM FactionMembers WHERE FactionName=?";
    private static final String SELECT_CLAIMS_WHERE_FACTIONNAME = "SELECT * FROM Claims WHERE FactionName=?";
    private static final String SELECT_CHEST_WHERE_FACTIONNAME = "SELECT ChestItems FROM FactionChests WHERE FactionName=?";
    private static final String SELECT_LEADER_PERMS_WHERE_FACTIONNAME = "SELECT * FROM LeaderPerms WHERE FactionName=?";
    private static final String SELECT_OFFICER_PERMS_WHERE_FACTIONNAME = "SELECT * FROM OfficerPerms WHERE FactionName=?";
    private static final String SELECT_MEMBER_PERMS_WHERE_FACTIONNAME = "SELECT * FROM MemberPerms WHERE FactionName=?";
    private static final String SELECT_RECRUIT_PERMS_WHERE_FACTIONNAME = "SELECT * FROM RecruitPerms WHERE FactionName=?";
    private static final String SELECT_TRUCE_PERMS_WHERE_FACTIONNAME = "SELECT * FROM TrucePerms WHERE FactionName=?";
    private static final String SELECT_ALLY_PERMS_WHERE_FACTIONNAME = "SELECT * FROM AllyPerms WHERE FactionName=?";
    private static final String SELECT_FACTION_WHERE_FACTIONNAME = "SELECT * FROM Factions WHERE Name=?";
    private static final String DELETE_FACTION_WHERE_FACTIONNAME = "DELETE FROM Factions WHERE Name=?";
    private static final String DELETE_OFFICERS_WHERE_FACIONNAME = "DELETE FROM FactionOfficers WHERE FactionName=?";
    private static final String DELETE_MEMBERS_WHERE_FACIONNAME = "DELETE FROM FactionMembers WHERE FactionName=?";
    private static final String DELETE_RECRUITS_WHERE_FACIONNAME = "DELETE FROM FactionRecruits WHERE FactionName=?";
    private static final String DELETE_FACTION_CHEST_WHERE_FACTIONNAME = "DELETE FROM FactionChests WHERE FactionName=?";
    private static final String INSERT_FACTION = "INSERT INTO Factions (Name, Tag, TagColor, Leader, Home, LastOnline, Truces, Alliances, Enemies, Description, Motd, IsPublic) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_FACTION = "UPDATE Factions SET Name = ?, Tag = ?, TagColor = ?, Leader = ?, Home = ?, LastOnline = ?, Truces = ?, Alliances = ?, Enemies = ?, Description = ?, Motd = ?, IsPublic = ? WHERE Name = ?";
    private static final String INSERT_CLAIM = "INSERT INTO Claims (FactionName, WorldUUID, ChunkPosition) VALUES (?, ?, ?)";
    private static final String DELETE_CLAIM_WHERE_FACTIONNAME = "DELETE FROM Claims WHERE FactionName=?";
    private static final String MERGE_CHEST = "MERGE INTO FactionChests (FactionName, ChestItems) KEY (FactionName) VALUES (?, ?)";
    private static final String MERGE_OFFICERS = "MERGE INTO FactionOfficers (OfficerUUID, FactionName) KEY (OfficerUUID) VALUES (?, ?)";
    private static final String MERGE_MEMBERS = "MERGE INTO FactionMembers (MemberUUID, FactionName) KEY (MemberUUID) VALUES (?, ?)";
    private static final String MERGE_RECRUITS = "MERGE INTO FactionRecruits (RecruitUUID, FactionName) KEY (RecruitUUID) VALUES (?, ?)";
    private static final String INSERT_CHEST = "INSERT INTO FactionChests (FactionName, ChestItems) VALUES (?, ?)";
    private static final String INSERT_OFFICERS = "INSERT INTO FactionOfficers (OfficerUUID, FactionName) VALUES (?, ?)";
    private static final String INSERT_MEMBERS = "INSERT INTO FactionMembers (MemberUUID, FactionName) VALUES (?, ?)";
    private static final String INSERT_RECRUITS = "INSERT INTO FactionRecruits (RecruitUUID, FactionName) VALUES (?, ?)";
    private static final String MERGE_LEADER_PERMS = "MERGE INTO LeaderPerms (FactionName, Use, Place, Destroy, Claim, Attack, Invite) KEY (FactionName) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String MERGE_OFFICER_PERMS = "MERGE INTO OfficerPerms (FactionName, Use, Place, Destroy, Claim, Attack, Invite) KEY (FactionName) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String MERGE_MEMBER_PERMS = "MERGE INTO MemberPerms (FactionName, Use, Place, Destroy, Claim, Attack, Invite) KEY (FactionName) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String MERGE_RECRUIT_PERMS = "MERGE INTO RecruitPerms (FactionName, Use, Place, Destroy, Claim, Attack, Invite) KEY (FactionName) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String MERGE_ALLY_PERMS = "MERGE INTO AllyPerms (FactionName, Use, Place, Destroy) KEY (FactionName) VALUES (?, ?, ?, ?)";
    private static final String INSERT_LEADER_PERMS = "INSERT INTO LeaderPerms (FactionName, `Use`, Place, Destroy, Claim, Attack, Invite) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_OFFICER_PERMS = "INSERT INTO OfficerPerms (FactionName, `Use`, Place, Destroy, Claim, Attack, Invite) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_MEMBER_PERMS = "INSERT INTO MemberPerms (FactionName, `Use`, Place, Destroy, Claim, Attack, Invite) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_RECRUIT_PERMS = "INSERT INTO RecruitPerms (FactionName, `Use`, Place, Destroy, Claim, Attack, Invite) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_ALLY_PERMS = "INSERT INTO AllyPerms (FactionName, `Use`, Place, Destroy) VALUES (?, ?, ?, ?)";
    private static final String UPDATE_LEADER_PERMS = "UPDATE LeaderPerms SET FactionName = ?, `Use` = ?, Place = ?, Destroy = ?, Claim = ?, Attack = ?, Invite = ? WHERE FactionName = ?";
    private static final String UPDATE_OFFICER_PERMS = "UPDATE OfficerPerms SET FactionName = ?, `Use` = ?, Place = ?, Destroy = ?, Claim = ?, Attack = ?, Invite = ? WHERE FactionName = ?";
    private static final String UPDATE_MEMBER_PERMS = "UPDATE MemberPerms SET FactionName = ?, `Use` = ?, Place = ?, Destroy = ?, Claim = ?, Attack = ?, Invite = ? WHERE FactionName = ?";
    private static final String UPDATE_RECRUIT_PERMS = "UPDATE RecruitPerms SET FactionName = ?, `Use` = ?, Place = ?, Destroy = ?, Claim = ?, Attack = ?, Invite = ? WHERE FactionName = ?";
    private static final String UPDATE_ALLY_PERMS = "UPDATE AllyPerms SET FactionName = ?, `Use` = ?, Place = ?, Destroy = ? WHERE FactionName = ?";
    private final EagleFactions plugin;
    private final SQLProvider sqlProvider;

    protected AbstractFactionStorage(EagleFactions plugin, SQLProvider sqlProvider) {
        this.plugin = plugin;
        this.sqlProvider = sqlProvider;
        if (this.sqlProvider == null) {
            Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not establish connection to the database. Aborting..."}));
            Sponge.getServer().shutdown();
        }
        try {
            int databaseVersionNumber = this.getDatabaseVersion();
            ArrayList<Path> filePaths = new ArrayList<Path>();
            URL url = this.plugin.getResource("/assets/eaglefactions/queries/" + this.sqlProvider.getProviderName());
            if (url != null) {
                Path myPath;
                URI uri = url.toURI();
                if (uri.getScheme().equals("jar")) {
                    FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    myPath = fileSystem.getPath("/assets/eaglefactions/queries/" + this.sqlProvider.getProviderName(), new String[0]);
                } else {
                    myPath = Paths.get(uri);
                }
                Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
                boolean skipFirst = true;
                Iterator it = walk.iterator();
                while (it.hasNext()) {
                    if (skipFirst) {
                        it.next();
                        skipFirst = false;
                    }
                    Path zipPath = (Path)it.next();
                    filePaths.add(zipPath);
                }
            }
            filePaths.sort(Comparator.comparing(x -> x.getFileName().toString()));
            if (!filePaths.isEmpty()) {
                for (Path resourceFilePath : filePaths) {
                    int scriptNumber = Integer.parseInt(resourceFilePath.getFileName().toString().substring(0, 3));
                    if (scriptNumber <= databaseVersionNumber) continue;
                    try {
                        InputStream inputStream = Files.newInputStream(resourceFilePath, StandardOpenOption.READ);
                        Throwable throwable = null;
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            Throwable throwable2 = null;
                            try {
                                Statement statement = this.sqlProvider.getConnection().createStatement();
                                Throwable throwable3 = null;
                                try {
                                    String line;
                                    StringBuilder stringBuilder = new StringBuilder();
                                    while ((line = bufferedReader.readLine()) != null) {
                                        if (line.startsWith("--")) continue;
                                        stringBuilder.append(line);
                                        if (!line.endsWith(";")) continue;
                                        statement.addBatch(stringBuilder.toString().trim());
                                        stringBuilder.setLength(0);
                                    }
                                    statement.executeBatch();
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (statement == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    statement.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (bufferedReader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                bufferedReader.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else {
                System.out.println("There may be a problem with database script files...");
                System.out.println("Searched for them in: " + this.sqlProvider.getProviderName());
                Sponge.getServer().shutdown();
            }
            if (databaseVersionNumber == 0) {
                this.precreate();
            }
        }
        catch (IOException | URISyntaxException | SQLException e) {
            e.printStackTrace();
            Sponge.getServer().shutdown();
        }
    }

    private int getDatabaseVersion() throws SQLException {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = null;
            if (this.sqlProvider instanceof H2Provider) {
                preparedStatement = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'VERSION'");
            } else if (this.sqlProvider instanceof MySQLProvider || this.sqlProvider instanceof MariaDbProvider) {
                preparedStatement = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'Version'");
                preparedStatement.setString(1, this.plugin.getConfiguration().getStorageConfig().getDatabaseName());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            boolean versionTableExists = false;
            while (resultSet.next()) {
                versionTableExists = true;
            }
            if (versionTableExists) {
                Statement statement = connection.createStatement();
                ResultSet resultSet1 = statement.executeQuery("SELECT Version FROM Version");
                if (resultSet1.last()) {
                    int n = resultSet1.getInt("Version");
                    return n;
                }
                statement.close();
            }
            preparedStatement.close();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addOrUpdateFaction(Faction faction) {
        Connection connection = null;
        try {
            void var6_16;
            void var5_11;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : faction.getTruces()) {
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            String truces = stringBuilder.toString();
            stringBuilder.setLength(0);
            for (String string : faction.getAlliances()) {
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            String string = stringBuilder.toString();
            stringBuilder.setLength(0);
            for (String enemy : faction.getEnemies()) {
                stringBuilder.append(enemy);
                stringBuilder.append(",");
            }
            String string2 = stringBuilder.toString();
            if (truces.endsWith(",")) {
                truces = truces.substring(0, truces.length() - 1);
            }
            if (string.endsWith(",")) {
                String string3 = string.substring(0, string.length() - 1);
            }
            if (string2.endsWith(",")) {
                String string4 = string2.substring(0, string2.length() - 1);
            }
            connection = this.sqlProvider.getConnection();
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(SELECT_FACTION_WHERE_FACTIONNAME);
            preparedStatement.setString(1, faction.getName());
            ResultSet factionSelect = preparedStatement.executeQuery();
            boolean exists = factionSelect.next();
            String queryToUse = exists ? UPDATE_FACTION : INSERT_FACTION;
            preparedStatement = connection.prepareStatement(queryToUse);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setString(2, faction.getTag().toPlain());
            preparedStatement.setString(3, faction.getTag().getColor().getId());
            preparedStatement.setString(4, faction.getLeader().toString());
            if (faction.getHome() != null) {
                preparedStatement.setString(5, faction.getHome().toString());
            } else {
                preparedStatement.setString(5, null);
            }
            preparedStatement.setString(6, faction.getLastOnline().toString());
            preparedStatement.setString(7, truces);
            preparedStatement.setString(8, (String)var5_11);
            preparedStatement.setString(9, (String)var6_16);
            preparedStatement.setString(10, faction.getDescription());
            preparedStatement.setString(11, faction.getMessageOfTheDay());
            preparedStatement.setString(12, faction.isPublic() ? "1" : "0");
            if (exists) {
                preparedStatement.setString(13, faction.getName());
            }
            preparedStatement.execute();
            preparedStatement.close();
            this.deleteFactionOfficers(connection, faction.getName());
            this.deleteFactionMembers(connection, faction.getName());
            this.deleteFactionRecruits(connection, faction.getName());
            this.deleteFactionClaims(connection, faction.getName());
            for (UUID officer : faction.getOfficers()) {
                preparedStatement = connection.prepareStatement(INSERT_OFFICERS);
                preparedStatement.setString(1, officer.toString());
                preparedStatement.setString(2, faction.getName());
                preparedStatement.execute();
                preparedStatement.close();
            }
            for (UUID member : faction.getMembers()) {
                preparedStatement = connection.prepareStatement(INSERT_MEMBERS);
                preparedStatement.setString(1, member.toString());
                preparedStatement.setString(2, faction.getName());
                preparedStatement.execute();
                preparedStatement.close();
            }
            for (UUID recruit : faction.getRecruits()) {
                preparedStatement = connection.prepareStatement(INSERT_RECRUITS);
                preparedStatement.setString(1, recruit.toString());
                preparedStatement.setString(2, faction.getName());
                preparedStatement.execute();
                preparedStatement.close();
            }
            for (Claim claim : faction.getClaims()) {
                preparedStatement = connection.prepareStatement(INSERT_CLAIM);
                preparedStatement.setString(1, faction.getName());
                preparedStatement.setString(2, claim.getWorldUUID().toString());
                preparedStatement.setString(3, claim.getChunkPosition().toString());
                preparedStatement.execute();
                preparedStatement.close();
            }
            List<DataView> dataViews = InventorySerializer.serializeInventory(faction.getChest().getInventory());
            DataContainer dataContainer = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.ALL_DATA_CLONED);
            dataContainer.set(DataQuery.of((String[])new String[]{"inventory"}), dataViews);
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            DataFormats.NBT.writeTo((OutputStream)byteArrayStream, (DataView)dataContainer);
            byteArrayStream.flush();
            byte[] chestBytes = byteArrayStream.toByteArray();
            byteArrayStream.close();
            preparedStatement = connection.prepareStatement(DELETE_FACTION_CHEST_WHERE_FACTIONNAME);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement(INSERT_CHEST);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setBytes(2, chestBytes);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(exists ? UPDATE_LEADER_PERMS : INSERT_LEADER_PERMS);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setBoolean(2, faction.getPerms().get((Object)FactionMemberType.LEADER).get((Object)FactionPermType.USE));
            preparedStatement.setBoolean(3, faction.getPerms().get((Object)FactionMemberType.LEADER).get((Object)FactionPermType.PLACE));
            preparedStatement.setBoolean(4, faction.getPerms().get((Object)FactionMemberType.LEADER).get((Object)FactionPermType.DESTROY));
            preparedStatement.setBoolean(5, faction.getPerms().get((Object)FactionMemberType.LEADER).get((Object)FactionPermType.CLAIM));
            preparedStatement.setBoolean(6, faction.getPerms().get((Object)FactionMemberType.LEADER).get((Object)FactionPermType.ATTACK));
            preparedStatement.setBoolean(7, faction.getPerms().get((Object)FactionMemberType.LEADER).get((Object)FactionPermType.INVITE));
            if (exists) {
                preparedStatement.setString(8, faction.getName());
            }
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(exists ? UPDATE_OFFICER_PERMS : INSERT_OFFICER_PERMS);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setBoolean(2, faction.getPerms().get((Object)FactionMemberType.OFFICER).get((Object)FactionPermType.USE));
            preparedStatement.setBoolean(3, faction.getPerms().get((Object)FactionMemberType.OFFICER).get((Object)FactionPermType.PLACE));
            preparedStatement.setBoolean(4, faction.getPerms().get((Object)FactionMemberType.OFFICER).get((Object)FactionPermType.DESTROY));
            preparedStatement.setBoolean(5, faction.getPerms().get((Object)FactionMemberType.OFFICER).get((Object)FactionPermType.CLAIM));
            preparedStatement.setBoolean(6, faction.getPerms().get((Object)FactionMemberType.OFFICER).get((Object)FactionPermType.ATTACK));
            preparedStatement.setBoolean(7, faction.getPerms().get((Object)FactionMemberType.OFFICER).get((Object)FactionPermType.INVITE));
            if (exists) {
                preparedStatement.setString(8, faction.getName());
            }
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(exists ? UPDATE_MEMBER_PERMS : INSERT_MEMBER_PERMS);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setBoolean(2, faction.getPerms().get((Object)FactionMemberType.MEMBER).get((Object)FactionPermType.USE));
            preparedStatement.setBoolean(3, faction.getPerms().get((Object)FactionMemberType.MEMBER).get((Object)FactionPermType.PLACE));
            preparedStatement.setBoolean(4, faction.getPerms().get((Object)FactionMemberType.MEMBER).get((Object)FactionPermType.DESTROY));
            preparedStatement.setBoolean(5, faction.getPerms().get((Object)FactionMemberType.MEMBER).get((Object)FactionPermType.CLAIM));
            preparedStatement.setBoolean(6, faction.getPerms().get((Object)FactionMemberType.MEMBER).get((Object)FactionPermType.ATTACK));
            preparedStatement.setBoolean(7, faction.getPerms().get((Object)FactionMemberType.MEMBER).get((Object)FactionPermType.INVITE));
            if (exists) {
                preparedStatement.setString(8, faction.getName());
            }
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(exists ? UPDATE_RECRUIT_PERMS : INSERT_RECRUIT_PERMS);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setBoolean(2, faction.getPerms().get((Object)FactionMemberType.RECRUIT).get((Object)FactionPermType.USE));
            preparedStatement.setBoolean(3, faction.getPerms().get((Object)FactionMemberType.RECRUIT).get((Object)FactionPermType.PLACE));
            preparedStatement.setBoolean(4, faction.getPerms().get((Object)FactionMemberType.RECRUIT).get((Object)FactionPermType.DESTROY));
            preparedStatement.setBoolean(5, faction.getPerms().get((Object)FactionMemberType.RECRUIT).get((Object)FactionPermType.CLAIM));
            preparedStatement.setBoolean(6, faction.getPerms().get((Object)FactionMemberType.RECRUIT).get((Object)FactionPermType.ATTACK));
            preparedStatement.setBoolean(7, faction.getPerms().get((Object)FactionMemberType.RECRUIT).get((Object)FactionPermType.INVITE));
            if (exists) {
                preparedStatement.setString(8, faction.getName());
            }
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(exists ? UPDATE_ALLY_PERMS : INSERT_ALLY_PERMS);
            preparedStatement.setString(1, faction.getName());
            preparedStatement.setBoolean(2, faction.getPerms().get((Object)FactionMemberType.ALLY).get((Object)FactionPermType.USE));
            preparedStatement.setBoolean(3, faction.getPerms().get((Object)FactionMemberType.ALLY).get((Object)FactionPermType.PLACE));
            preparedStatement.setBoolean(4, faction.getPerms().get((Object)FactionMemberType.ALLY).get((Object)FactionPermType.DESTROY));
            if (exists) {
                preparedStatement.setString(5, faction.getName());
            }
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
            connection.close();
            return true;
        }
        catch (IOException | SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return false;
        }
    }

    private boolean deleteFactionOfficers(Connection connection, String name) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(DELETE_OFFICERS_WHERE_FACIONNAME);
        preparedStatement.setString(1, name);
        boolean didSucceed = preparedStatement.execute();
        preparedStatement.close();
        return didSucceed;
    }

    private boolean deleteFactionMembers(Connection connection, String name) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(DELETE_MEMBERS_WHERE_FACIONNAME);
        preparedStatement.setString(1, name);
        boolean didSucceed = preparedStatement.execute();
        preparedStatement.close();
        return didSucceed;
    }

    private boolean deleteFactionRecruits(Connection connection, String name) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(DELETE_RECRUITS_WHERE_FACIONNAME);
        preparedStatement.setString(1, name);
        boolean didSucceed = preparedStatement.execute();
        preparedStatement.close();
        return didSucceed;
    }

    private boolean deleteFactionClaims(Connection connection, String name) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(DELETE_CLAIM_WHERE_FACTIONNAME);
        preparedStatement.setString(1, name);
        boolean didSucceed = preparedStatement.execute();
        preparedStatement.close();
        return didSucceed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Faction getFaction(String factionName) {
        try (Connection connection = this.sqlProvider.getConnection();){
            Faction faction2;
            PreparedStatement statement = connection.prepareStatement(SELECT_FACTION_WHERE_FACTIONNAME);
            statement.setString(1, factionName);
            ResultSet factionsResultSet = statement.executeQuery();
            if (!factionsResultSet.first()) return null;
            String tag = factionsResultSet.getString("Tag");
            String tagColor = factionsResultSet.getString("TagColor");
            TextColor textColor = Sponge.getRegistry().getType(TextColor.class, tagColor).orElse(TextColors.RESET);
            UUID leaderUUID = UUID.fromString(factionsResultSet.getString("Leader"));
            String factionHomeAsString = factionsResultSet.getString("Home");
            String description = factionsResultSet.getString("Description");
            String messageOfTheDay = factionsResultSet.getString("Motd");
            boolean isPublic = factionsResultSet.getBoolean("IsPublic");
            FactionHome factionHome = null;
            if (factionHomeAsString != null) {
                factionHome = FactionHome.from(factionHomeAsString);
            }
            String lastOnlineString = factionsResultSet.getString("LastOnline");
            Instant lastOnline = Instant.parse(lastOnlineString);
            HashSet<String> truces = new HashSet<String>(Arrays.asList(factionsResultSet.getString("Truces").split(",")));
            HashSet<String> alliances = new HashSet<String>(Arrays.asList(factionsResultSet.getString("Alliances").split(",")));
            HashSet<String> enemies = new HashSet<String>(Arrays.asList(factionsResultSet.getString("Enemies").split(",")));
            Set<UUID> officers = this.getFactionOfficers(connection, factionName);
            Set<UUID> recruits = this.getFactionRecruits(connection, factionName);
            Set<UUID> members = this.getFactionMembers(connection, factionName);
            Set<Claim> claims = this.getFactionClaims(connection, factionName);
            FactionChest factionChest = this.getFactionChest(connection, factionName);
            Map<FactionMemberType, Map<FactionPermType, Boolean>> perms = this.getFactionPerms(connection, factionName);
            Faction faction = faction2 = FactionImpl.builder(factionName, Text.of((Object[])new Object[]{textColor, tag}), leaderUUID).setHome(factionHome).setTruces(truces).setAlliances(alliances).setEnemies(enemies).setClaims(claims).setLastOnline(lastOnline).setMembers(members).setRecruits(recruits).setOfficers(officers).setChest(factionChest).setPerms(perms).setDescription(description).setMessageOfTheDay(messageOfTheDay).setIsPublic(isPublic).build();
            return faction;
        }
        catch (IOException | ClassNotFoundException | SQLException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public Set<Faction> getFactions() {
        HashSet<Faction> factions = new HashSet<Faction>();
        try {
            Connection connection = this.sqlProvider.getConnection();
            ResultSet resultSet = connection.createStatement().executeQuery(SELECT_FACTION_NAMES);
            ArrayList<String> factionsNames = new ArrayList<String>();
            while (resultSet.next()) {
                factionsNames.add(resultSet.getString("Name"));
            }
            connection.close();
            for (String factionName : factionsNames) {
                Faction faction = this.getFaction(factionName);
                if (faction == null) continue;
                factions.add(faction);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return factions;
    }

    @Override
    public void load() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteFaction(String factionName) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(DELETE_FACTION_WHERE_FACTIONNAME);
            preparedStatement.setString(1, factionName);
            boolean didSucceed = preparedStatement.execute();
            preparedStatement.close();
            connection.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private Set<UUID> getFactionRecruits(Connection connection, String factionName) throws SQLException {
        HashSet<UUID> recruits = new HashSet<UUID>();
        PreparedStatement preparedStatement = connection.prepareStatement(SELECT_RECRUITS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet recruitsResultSet = preparedStatement.executeQuery();
        while (recruitsResultSet.next()) {
            UUID recruitUUID = UUID.fromString(recruitsResultSet.getString("RecruitUUID"));
            recruits.add(recruitUUID);
        }
        recruitsResultSet.close();
        preparedStatement.close();
        return recruits;
    }

    private Set<UUID> getFactionMembers(Connection connection, String factionName) throws SQLException {
        HashSet<UUID> members = new HashSet<UUID>();
        PreparedStatement preparedStatement = connection.prepareStatement(SELECT_MEMBERS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            UUID memberUUID = UUID.fromString(resultSet.getString("MemberUUID"));
            members.add(memberUUID);
        }
        resultSet.close();
        preparedStatement.close();
        return members;
    }

    private Set<UUID> getFactionOfficers(Connection connection, String factionName) throws SQLException {
        HashSet<UUID> officers = new HashSet<UUID>();
        PreparedStatement preparedStatement = connection.prepareStatement(SELECT_OFFICERS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            UUID officerUUID = UUID.fromString(resultSet.getString("OfficerUUID"));
            officers.add(officerUUID);
        }
        resultSet.close();
        preparedStatement.close();
        return officers;
    }

    private Set<Claim> getFactionClaims(Connection connection, String factionName) throws SQLException {
        HashSet<Claim> claims = new HashSet<Claim>();
        PreparedStatement preparedStatement = connection.prepareStatement(SELECT_CLAIMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String worldUUID = resultSet.getString("WorldUUID");
            String chunkPosition = resultSet.getString("ChunkPosition");
            Claim claim = Claim.valueOf(worldUUID + "|" + chunkPosition);
            claims.add(claim);
        }
        resultSet.close();
        preparedStatement.close();
        return claims;
    }

    private FactionChest getFactionChest(Connection connection, String factionName) throws SQLException, IOException, ClassNotFoundException {
        FactionChestImpl factionChest = new FactionChestImpl(factionName);
        PreparedStatement preparedStatement = connection.prepareStatement(SELECT_CHEST_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.first()) {
            byte[] factionChestItems = resultSet.getBytes("ChestItems");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(factionChestItems);
            DataContainer dataContainer = DataFormats.NBT.readFrom((InputStream)byteArrayInputStream);
            byteArrayInputStream.close();
            Inventory inventory = Inventory.builder().of(InventoryArchetypes.CHEST).build((Object)this.plugin);
            InventorySerializer.deserializeInventory(dataContainer.getViewList(DataQuery.of((String[])new String[]{"inventory"})).orElse(new ArrayList()), inventory);
            factionChest = new FactionChestImpl(factionName, inventory);
        }
        resultSet.close();
        preparedStatement.close();
        return factionChest;
    }

    private Map<FactionMemberType, Map<FactionPermType, Boolean>> getFactionPerms(Connection connection, String factionName) throws SQLException {
        LinkedHashMap<FactionMemberType, Map<FactionPermType, Boolean>> permMap = new LinkedHashMap<FactionMemberType, Map<FactionPermType, Boolean>>();
        LinkedHashMap<FactionPermType, Boolean> leaderMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> officerMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> membersMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> recruitMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> allyMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> truceMap = new LinkedHashMap<FactionPermType, Boolean>();
        PreparedStatement preparedStatement = connection.prepareStatement(SELECT_LEADER_PERMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet leaderResult = preparedStatement.executeQuery();
        boolean leaderUSE = true;
        boolean leaderPLACE = true;
        boolean leaderDESTROY = true;
        boolean leaderCLAIM = true;
        boolean leaderATTACK = true;
        boolean leaderINVITE = true;
        if (leaderResult.first()) {
            leaderUSE = leaderResult.getBoolean("Use");
            leaderPLACE = leaderResult.getBoolean("Place");
            leaderDESTROY = leaderResult.getBoolean("Destroy");
            leaderCLAIM = leaderResult.getBoolean("Claim");
            leaderATTACK = leaderResult.getBoolean("Attack");
            leaderINVITE = leaderResult.getBoolean("Invite");
        }
        leaderResult.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement(SELECT_OFFICER_PERMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet officerResult = preparedStatement.executeQuery();
        boolean officerUSE = true;
        boolean officerPLACE = true;
        boolean officerDESTROY = true;
        boolean officerCLAIM = true;
        boolean officerATTACK = true;
        boolean officerINVITE = true;
        if (officerResult.first()) {
            officerUSE = officerResult.getBoolean("Use");
            officerPLACE = officerResult.getBoolean("Place");
            officerDESTROY = officerResult.getBoolean("Destroy");
            officerCLAIM = officerResult.getBoolean("Claim");
            officerATTACK = officerResult.getBoolean("Attack");
            officerINVITE = officerResult.getBoolean("Invite");
        }
        officerResult.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement(SELECT_MEMBER_PERMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet memberResult = preparedStatement.executeQuery();
        boolean memberUSE = true;
        boolean memberPLACE = true;
        boolean memberDESTROY = true;
        boolean memberCLAIM = false;
        boolean memberATTACK = false;
        boolean memberINVITE = true;
        if (memberResult.first()) {
            memberUSE = memberResult.getBoolean("Use");
            memberPLACE = memberResult.getBoolean("Place");
            memberDESTROY = memberResult.getBoolean("Destroy");
            memberCLAIM = memberResult.getBoolean("Claim");
            memberATTACK = memberResult.getBoolean("Attack");
            memberINVITE = memberResult.getBoolean("Invite");
        }
        memberResult.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement(SELECT_RECRUIT_PERMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet recruitResult = preparedStatement.executeQuery();
        boolean recruitUSE = true;
        boolean recruitPLACE = true;
        boolean recruitDESTROY = true;
        boolean recruitCLAIM = false;
        boolean recruitATTACK = false;
        boolean recruitINVITE = false;
        if (recruitResult.first()) {
            recruitUSE = recruitResult.getBoolean("Use");
            recruitPLACE = recruitResult.getBoolean("Place");
            recruitDESTROY = recruitResult.getBoolean("Destroy");
            recruitCLAIM = recruitResult.getBoolean("Claim");
            recruitATTACK = recruitResult.getBoolean("Attack");
            recruitINVITE = recruitResult.getBoolean("Invite");
        }
        recruitResult.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement(SELECT_TRUCE_PERMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet truceResult = preparedStatement.executeQuery();
        boolean truceUSE = true;
        boolean trucePLACE = false;
        boolean truceDESTROY = false;
        if (truceResult.first()) {
            truceUSE = truceResult.getBoolean("Use");
            trucePLACE = truceResult.getBoolean("Place");
            truceDESTROY = truceResult.getBoolean("Destroy");
        }
        truceResult.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement(SELECT_ALLY_PERMS_WHERE_FACTIONNAME);
        preparedStatement.setString(1, factionName);
        ResultSet allyResult = preparedStatement.executeQuery();
        boolean allyUSE = true;
        boolean allyPLACE = true;
        boolean allyDESTROY = true;
        if (allyResult.first()) {
            allyUSE = allyResult.getBoolean("Use");
            allyPLACE = allyResult.getBoolean("Place");
            allyDESTROY = allyResult.getBoolean("Destroy");
        }
        allyResult.close();
        preparedStatement.close();
        leaderMap.put(FactionPermType.USE, leaderUSE);
        leaderMap.put(FactionPermType.PLACE, leaderPLACE);
        leaderMap.put(FactionPermType.DESTROY, leaderDESTROY);
        leaderMap.put(FactionPermType.CLAIM, leaderCLAIM);
        leaderMap.put(FactionPermType.ATTACK, leaderATTACK);
        leaderMap.put(FactionPermType.INVITE, leaderINVITE);
        officerMap.put(FactionPermType.USE, officerUSE);
        officerMap.put(FactionPermType.PLACE, officerPLACE);
        officerMap.put(FactionPermType.DESTROY, officerDESTROY);
        officerMap.put(FactionPermType.CLAIM, officerCLAIM);
        officerMap.put(FactionPermType.ATTACK, officerATTACK);
        officerMap.put(FactionPermType.INVITE, officerINVITE);
        membersMap.put(FactionPermType.USE, memberUSE);
        membersMap.put(FactionPermType.PLACE, memberPLACE);
        membersMap.put(FactionPermType.DESTROY, memberDESTROY);
        membersMap.put(FactionPermType.CLAIM, memberCLAIM);
        membersMap.put(FactionPermType.ATTACK, memberATTACK);
        membersMap.put(FactionPermType.INVITE, memberINVITE);
        recruitMap.put(FactionPermType.USE, recruitUSE);
        recruitMap.put(FactionPermType.PLACE, recruitPLACE);
        recruitMap.put(FactionPermType.DESTROY, recruitDESTROY);
        recruitMap.put(FactionPermType.CLAIM, recruitCLAIM);
        recruitMap.put(FactionPermType.ATTACK, recruitATTACK);
        recruitMap.put(FactionPermType.INVITE, recruitINVITE);
        truceMap.put(FactionPermType.USE, truceUSE);
        truceMap.put(FactionPermType.PLACE, trucePLACE);
        truceMap.put(FactionPermType.DESTROY, truceDESTROY);
        allyMap.put(FactionPermType.USE, allyUSE);
        allyMap.put(FactionPermType.PLACE, allyPLACE);
        allyMap.put(FactionPermType.DESTROY, allyDESTROY);
        permMap.put(FactionMemberType.LEADER, leaderMap);
        permMap.put(FactionMemberType.OFFICER, officerMap);
        permMap.put(FactionMemberType.MEMBER, membersMap);
        permMap.put(FactionMemberType.RECRUIT, recruitMap);
        permMap.put(FactionMemberType.TRUCE, truceMap);
        permMap.put(FactionMemberType.ALLY, allyMap);
        return permMap;
    }

    private void precreate() {
        try (Connection connection = this.sqlProvider.getConnection();){
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(INSERT_FACTION);
            preparedStatement.setString(1, "WarZone");
            preparedStatement.setString(2, "SZ");
            preparedStatement.setString(3, "");
            preparedStatement.setString(4, new UUID(0L, 0L).toString());
            preparedStatement.setString(5, null);
            preparedStatement.setString(6, Instant.now().toString());
            preparedStatement.setString(7, "");
            preparedStatement.setString(8, "");
            preparedStatement.setString(9, "");
            preparedStatement.setString(10, "");
            preparedStatement.setString(11, "");
            preparedStatement.setString(12, "0");
            PreparedStatement preparedStatement1 = connection.prepareStatement(INSERT_FACTION);
            preparedStatement1.setString(1, "SafeZone");
            preparedStatement1.setString(2, "WZ");
            preparedStatement1.setString(3, "");
            preparedStatement1.setString(4, new UUID(0L, 0L).toString());
            preparedStatement1.setString(5, null);
            preparedStatement1.setString(6, Instant.now().toString());
            preparedStatement1.setString(7, "");
            preparedStatement1.setString(8, "");
            preparedStatement1.setString(9, "");
            preparedStatement1.setString(10, "");
            preparedStatement1.setString(11, "");
            preparedStatement1.setString(12, "0");
            preparedStatement.execute();
            preparedStatement1.execute();
            preparedStatement1.close();
            preparedStatement.close();
            connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

