/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql.mysql;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLAbstractProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQLProvider
extends SQLAbstractProvider
implements SQLProvider {
    private static MySQLProvider INSTANCE = null;
    private static final String CONNECTION_OPTIONS = "?useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC";

    public static MySQLProvider getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new MySQLProvider(eagleFactions);
                return INSTANCE;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return INSTANCE;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:mysql://" + super.getDatabaseUrl() + super.getDatabaseName() + CONNECTION_OPTIONS, super.getUsername(), super.getPassword());
    }

    @Override
    public String getProviderName() {
        return "mysql";
    }

    private MySQLProvider(EagleFactions eagleFactions) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        super(eagleFactions);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    private boolean databaseExists() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:mysql://" + super.getDatabaseUrl(), super.getUsername(), super.getPassword());
        ResultSet resultSet = connection.getMetaData().getCatalogs();
        while (resultSet.next()) {
            if (!resultSet.getString(1).equalsIgnoreCase(super.getDatabaseName())) continue;
            resultSet.close();
            connection.close();
            return true;
        }
        resultSet.close();
        connection.close();
        return false;
    }

    private void createDatabase() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:mysql://" + super.getDatabaseUrl() + "?user=" + super.getUsername() + "&password=" + super.getPassword() + CONNECTION_OPTIONS);
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA " + super.getDatabaseName() + ";");
        statement.close();
        connection.close();
    }
}

