/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeamReceiver
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, (double)0.7f, 1.0, (double)0.7f);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.42f, (double)0.8f);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB((double)0.58f, (double)0.2f, (double)0.2f, 1.0, (double)0.8f, (double)0.8f);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.2f, (double)0.42f, (double)0.8f, (double)0.8f);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB((double)0.2f, (double)0.2f, 0.0, (double)0.8f, (double)0.8f, (double)0.42f);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.58f, (double)0.8f, (double)0.8f, 1.0);

    public BlockBeamReceiver(String assetName) {
        super(Material.field_151573_f);
        this.func_149663_c(assetName);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int oldMeta = this.func_176201_c(worldIn.func_180495_p(pos));
        int meta = this.getMetadataFromAngle(worldIn, pos, EnumFacing.func_82600_a((int)oldMeta).func_176734_d());
        if (meta == -1) {
            worldIn.func_175655_b(pos, true);
        } else if (meta != oldMeta) {
            worldIn.func_180501_a(pos, this.func_176203_a(meta), 3);
            TileEntity thisTile = worldIn.func_175625_s(pos);
            if (thisTile instanceof TileEntityBeamReceiver) {
                TileEntityBeamReceiver thisReceiver = (TileEntityBeamReceiver)thisTile;
                thisReceiver.setFacing(EnumFacing.func_82600_a((int)meta));
                thisReceiver.invalidateReflector();
                thisReceiver.initiateReflector();
            }
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity thisTile = world.func_175625_s(pos);
        if (thisTile instanceof TileEntityBeamReceiver) {
            ((TileEntityBeamReceiver)thisTile).setFacing(EnumFacing.func_82600_a((int)this.func_176201_c(state)));
        }
    }

    private int getMetadataFromAngle(World world, BlockPos pos, EnumFacing side) {
        EnumFacing direction = side.func_176734_d();
        TileEntity tileAt = world.func_175625_s(pos.func_177982_a(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e()));
        if (tileAt instanceof EnergyStorageTile) {
            if (((EnergyStorageTile)tileAt).getModeFromDirection(direction.func_176734_d()) != null) {
                return direction.ordinal();
            }
            return -1;
        }
        if (EnergyUtil.otherModCanReceive((TileEntity)tileAt, (EnumFacing)direction.func_176734_d())) {
            return direction.ordinal();
        }
        for (EnumFacing adjacentDir : EnumFacing.field_82609_l) {
            if (adjacentDir == direction || (tileAt = world.func_175625_s(pos.func_177982_a(adjacentDir.func_82601_c(), adjacentDir.func_96559_d(), adjacentDir.func_82599_e()))) instanceof IConductor) continue;
            if (tileAt instanceof EnergyStorageTile && ((EnergyStorageTile)tileAt).getModeFromDirection(adjacentDir.func_176734_d()) != null) {
                return adjacentDir.ordinal();
            }
            if (!EnergyUtil.otherModCanReceive((TileEntity)tileAt, (EnumFacing)adjacentDir.func_176734_d())) continue;
            return adjacentDir.ordinal();
        }
        return -1;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(this.getMetadataFromAngle(world, pos, facing));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (this.getMetadataFromAngle(worldIn, pos, side) != -1) {
            return true;
        }
        if (worldIn.field_72995_K) {
            this.sendIncorrectSideMessage();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void sendIncorrectSideMessage() {
        FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(EnumColor.RED + GCCoreUtil.translate((String)"gui.receiver.cannot_attach")));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int func_180651_a(IBlockState metadata) {
        return 0;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        return new TileEntityBeamReceiver();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBeamReceiver) {
            return ((TileEntityBeamReceiver)tile).onMachineActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }
}

