/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import c4.conarm.lib.armor.ArmorModifications;
import c4.conarm.lib.capabilities.ArmorAbilityHandler;
import c4.conarm.lib.traits.IArmorAbility;
import c4.conarm.lib.traits.IArmorTrait;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import landmaster.plustic.api.Portal;
import landmaster.plustic.api.Toggle;
import landmaster.plustic.util.Coord4D;
import landmaster.plustic.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="c4.conarm.lib.traits.IArmorTrait", modid="conarm"), @Optional.Interface(iface="c4.conarm.lib.traits.IArmorAbility", modid="conarm")})
public abstract class DeathSaveTrait
extends AbstractTrait
implements IArmorTrait,
IArmorAbility {
    @CapabilityInject(value=Portal.IPortalArmor.class)
    private static Capability<Portal.IPortalArmor> PORTAL_ARMOR = null;
    @CapabilityInject(value=Toggle.IToggleArmor.class)
    private static Capability<Toggle.IToggleArmor> TOGGLE_ARMOR = null;
    private final int cost;
    private final Predicate<ItemStack> stackMatcher;
    private final String unlocSaveMessage;

    public DeathSaveTrait(String identifier, int color, int cost, Predicate<ItemStack> stackMatcher, String unlocSaveMessage) {
        super(identifier, color);
        this.cost = cost;
        this.stackMatcher = stackMatcher;
        this.unlocSaveMessage = unlocSaveMessage;
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.addToggleable(identifier);
        Toggle.addToggleable("\\" + identifier);
        Portal.addPortalable(identifier);
    }

    public String getLocalizedDesc() {
        return String.format(super.getLocalizedDesc(), this.cost);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void timing(LivingDeathEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K || !(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        if (Loader.isModLoaded((String)"conarm") && this.hasDeathSaveArmor((EntityPlayer)event.getEntity()) && event.getEntity().hasCapability(PORTAL_ARMOR, null) && event.getEntity().hasCapability(TOGGLE_ARMOR, null) && !((Toggle.IToggleArmor)event.getEntity().getCapability(TOGGLE_ARMOR, null)).getDisabled().contains(this.identifier) && Utils.canTeleportTo((EntityPlayer)event.getEntity(), ((Portal.IPortalArmor)event.getEntity().getCapability(PORTAL_ARMOR, null)).location()) && !((Portal.IPortalArmor)event.getEntity().getCapability(PORTAL_ARMOR, null)).location().equals(Coord4D.NIHIL)) {
            this.checkItems(event, ((Portal.IPortalArmor)event.getEntity().getCapability(PORTAL_ARMOR, null)).location());
        } else {
            Arrays.stream(EnumHand.values()).map(arg_0 -> ((EntityLivingBase)event.getEntityLiving()).func_184586_b(arg_0)).map(TagUtil::getTagSafe).filter(nbt -> TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)this.identifier) && Toggle.getToggleState(nbt, this.identifier) && nbt.func_150297_b("nickoftime", 10)).map(nbt -> nbt.func_74775_l("nickoftime")).map(Coord4D::fromNBT).filter(coord -> Utils.canTeleportTo((EntityPlayer)event.getEntity(), coord)).findFirst().ifPresent(coord -> this.checkItems(event, (Coord4D)coord));
        }
    }

    private boolean hasDeathSaveArmor(EntityPlayer player) {
        return Optional.ofNullable(ArmorAbilityHandler.getArmorAbilitiesData((EntityPlayer)player)).map(ArmorAbilityHandler.IArmorAbilities::getAbilityMap).filter(map -> map.containsKey(this.identifier)).isPresent();
    }

    private void checkItems(final LivingDeathEvent event, Coord4D coord) {
        IItemHandler ih = (IItemHandler)event.getEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < ih.getSlots(); ++i) {
            ItemStack is = ih.extractItem(i, this.cost, true);
            if (!this.stackMatcher.test(is) || is.func_190916_E() < this.cost) continue;
            ih.extractItem(i, this.cost, false);
            event.setCanceled(true);
            event.getEntityLiving().func_70674_bp();
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onServerTick(TickEvent.ServerTickEvent event0) {
                    if (!event.getEntityLiving().func_70027_ad()) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                    event.getEntityLiving().func_70066_B();
                }
            });
            event.getEntityLiving().func_70606_j(1.0f);
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76428_l, 160, 1));
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 160));
            event.getEntity().func_145747_a((ITextComponent)new TextComponentTranslation(this.unlocSaveMessage, new Object[0]));
            event.getEntity().field_70143_R = 0.0f;
            Utils.teleportPlayerTo((EntityPlayerMP)event.getEntity(), coord);
            return;
        }
    }

    public boolean disableRendering(ItemStack arg0, EntityLivingBase arg1) {
        return false;
    }

    @Optional.Method(modid="conarm")
    public ArmorModifications getModifications(EntityPlayer arg0, ArmorModifications arg1, ItemStack arg2, DamageSource arg3, double arg4, int arg5) {
        return arg1;
    }

    public void onAbilityTick(int arg0, World arg1, EntityPlayer arg2) {
    }

    public int onArmorDamage(ItemStack arg0, DamageSource arg1, int arg2, int arg3, EntityPlayer arg4, int arg5) {
        return arg3;
    }

    public void onArmorEquipped(ItemStack arg0, EntityPlayer arg1, int arg2) {
    }

    public int onArmorHeal(ItemStack arg0, DamageSource arg1, int arg2, int arg3, EntityPlayer arg4, int arg5) {
        return arg3;
    }

    public void onArmorRemoved(ItemStack arg0, EntityPlayer arg1, int arg2) {
    }

    public float onDamaged(ItemStack arg0, EntityPlayer arg1, DamageSource arg2, float arg3, float arg4, LivingDamageEvent arg5) {
        return arg4;
    }

    public void onFalling(ItemStack arg0, EntityPlayer arg1, LivingFallEvent arg2) {
    }

    public float onHeal(ItemStack arg0, EntityPlayer arg1, float arg2, float arg3, LivingHealEvent arg4) {
        return arg3;
    }

    public float onHurt(ItemStack arg0, EntityPlayer arg1, DamageSource arg2, float arg3, float arg4, LivingHurtEvent arg5) {
        return arg4;
    }

    public void onItemPickup(ItemStack arg0, EntityItem arg1, EntityItemPickupEvent arg2) {
    }

    public void onJumping(ItemStack arg0, EntityPlayer arg1, LivingEvent.LivingJumpEvent arg2) {
    }

    public void onKnockback(ItemStack arg0, EntityPlayer arg1, LivingKnockBackEvent arg2) {
    }

    public int getAbilityLevel(ModifierNBT arg0) {
        return arg0.level;
    }
}

