/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.reference.ConstantReference;

public class EntityWorldLocation
implements ConstantReference<IWorldLocation>,
IWorldLocation {
    private final Entity entity;

    public EntityWorldLocation(@Nonnull Entity entity) {
        Objects.requireNonNull(entity, "entity cannot be null");
        this.entity = entity;
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.entity.func_130014_f_();
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.func_70047_e(), this.entity.field_70161_v);
    }

    @Override
    @Nonnull
    public Vec3d getLoc() {
        return new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.func_70047_e(), this.entity.field_70161_v);
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBounds() {
        AxisAlignedBB bounds = this.entity.func_70046_E();
        return bounds == null ? this.entity.func_174813_aQ() : bounds;
    }

    @Override
    @Nonnull
    public IWorldLocation get() {
        return this;
    }

    @Override
    @Nonnull
    public IWorldLocation safeGet() {
        return new WorldLocation(this.getWorld(), this.getLoc());
    }
}

