/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import java.io.FileOutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.io.IOUtils;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.MetaRegistry;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.docdump.HTMLWriter;
import org.squiddev.plethora.core.docdump.IDocWriter;
import org.squiddev.plethora.core.docdump.JSONWriter;

public class CommandPlethora
extends CommandBase {
    private static final String USAGE = "dump | reload";
    private static final String USAGE_DUMP = "dump [--raw] <name>";
    private static final String USAGE_RELOAD = "reload";

    @Nonnull
    public String func_71517_b() {
        return "plethora";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return USAGE;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        String type = CommandPlethora.getArg(args, 0);
        if (Objects.equals(type, "dump")) {
            boolean raw = Objects.equals(CommandPlethora.getArg(args, 1), "--raw");
            String name = CommandPlethora.getArg(args, raw ? 2 : 1);
            if (name == null) {
                throw new CommandException(USAGE_DUMP, new Object[0]);
            }
            FileOutputStream stream = null;
            try {
                IDocWriter initialWriter;
                if (name.endsWith(".json")) {
                    stream = new FileOutputStream(name);
                    initialWriter = new JSONWriter(stream, MethodRegistry.instance.providers, MetaRegistry.instance.providers);
                } else if (name.endsWith(".html") || name.endsWith(".htm")) {
                    stream = new FileOutputStream(name);
                    initialWriter = new HTMLWriter(stream, MethodRegistry.instance.providers, MetaRegistry.instance.providers);
                } else {
                    throw new CommandException("Cannot generate documentation for '" + name + "'. The file must be suffixed with '.json', '.html'", new Object[0]);
                }
                try (JSONWriter writer = initialWriter;){
                    if (!raw) {
                        writer.writeHeader();
                    }
                    writer.write();
                    if (!raw) {
                        writer.writeFooter();
                    }
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Documentation written to " + name));
            }
            catch (CommandException e) {
                throw e;
            }
            catch (Exception e) {
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
                PlethoraCore.LOG.error("Cannot handle " + name, (Throwable)e);
                throw new CommandException(e.toString(), new Object[0]);
            }
        }
        if (Objects.equals(type, USAGE_RELOAD)) {
            ConfigCore.configuration.load();
            ConfigCore.sync();
            sender.func_145747_a((ITextComponent)new TextComponentString("Config reloaded"));
        } else {
            throw new CommandException(USAGE, new Object[0]);
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !server.func_71262_S() || super.func_184882_a(server, sender);
    }

    public int func_82362_a() {
        return 4;
    }

    private static String getArg(String[] args, int i) {
        return args.length > i ? args[i] : null;
    }
}

