/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import org.squiddev.plethora.gameplay.ConfigGameplay;

public final class RenderSquidOverlay {
    private static final UUID uuid = UUID.fromString("d3156e4b-c712-4fd3-87b0-b24b8ca94209");

    private RenderSquidOverlay() {
    }

    public static void init() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderLayer layer = new RenderLayer();
        ((RenderPlayer)skinMap.get("default")).func_177094_a((LayerRenderer)layer);
        ((RenderPlayer)skinMap.get("slim")).func_177094_a((LayerRenderer)layer);
    }

    private static final class RenderLayer
    implements LayerRenderer<EntityPlayer> {
        private static final int SEGMENTS = 5;
        private static final int TENTACLES = 6;
        private static final int BASE_ANGLE = 25;
        private static final float LENGTH = 0.3f;
        private static final float WIDTH = 0.15f;
        private static final double EASING_TICKS = 5.0;
        private static final double OFFSET_SPEED = 0.1;
        private static final double OFFSET_VARIANCE = 7.0;
        private final double[] lastAngles = new double[30];
        private final double[] offsets = new double[30];
        private double tick = 0.0;

        public RenderLayer() {
            for (int i = 0; i < this.lastAngles.length; ++i) {
                this.lastAngles[i] = 25.0;
                this.offsets[i] = Math.random() * Math.PI * 2.0;
            }
        }

        public void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            double angle;
            GameProfile profile = player.func_146103_bH();
            if (profile == null || !profile.getId().equals(uuid) || !ConfigGameplay.Miscellaneous.funRender) {
                return;
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179094_E();
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)-0.3);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (player.field_70737_aN > 0) {
                double progress = (double)player.field_70737_aN / (double)player.field_70738_aO;
                angle = 25.0 - progress * 18.0;
            } else {
                double velocity = new Vec3d(player.field_70142_S, player.field_70137_T, player.field_70136_U).func_72438_d(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                double adjusted = 1.0 - Math.exp(velocity * -2.0);
                angle = 25.0 - adjusted * 25.0;
            }
            this.tick = (this.tick + (double)partialTicks) % 62.83185307179586;
            for (int i = 0; i < 6; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(60.0f * (float)i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.1, (double)0.0, (double)0.0);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder renderer = tessellator.func_178180_c();
                for (int j = 0; j < 5; ++j) {
                    double lastAngle = this.lastAngles[i * 5 + j];
                    double thisAngle = angle + Math.sin(this.offsets[i * 5 + j] + this.tick * 0.1) * 7.0;
                    if (Math.abs(lastAngle - (thisAngle *= Math.cos((double)j * 0.7853981633974483))) > 1.0) {
                        thisAngle = lastAngle - (lastAngle - thisAngle) / 5.0;
                    }
                    this.lastAngles[i * 5 + j] = thisAngle;
                    GlStateManager.func_179114_b((float)((float)thisAngle), (float)0.0f, (float)0.0f, (float)-1.0f);
                    renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    RenderLayer.tentacle(renderer);
                    tessellator.func_78381_a();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.22500001f, (float)0.0f);
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }

        public boolean func_177142_b() {
            return false;
        }

        private static void tentacle(BufferBuilder renderer) {
            renderer.func_181662_b(0.0, 0.0, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, (double)0.075f).func_181675_d();
            renderer.func_181662_b(0.0, (double)0.3f, (double)0.075f).func_181675_d();
            renderer.func_181662_b(0.0, (double)0.3f, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, 0.0, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, 0.0, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, (double)0.3f, (double)-0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, (double)0.3f, (double)-0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, 0.0, (double)-0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, 0.0, (double)-0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, 0.0, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, (double)0.3f, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, (double)0.3f, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, (double)0.3f, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, (double)0.3f, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, (double)0.3f, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, (double)0.3f, (double)-0.075f).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, (double)0.075f).func_181675_d();
            renderer.func_181662_b(0.0, (double)0.3f, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, (double)0.3f, (double)0.075f).func_181675_d();
            renderer.func_181662_b((double)0.15f, 0.0, (double)0.075f).func_181675_d();
        }
    }
}

