/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.gameplay.ItemBase;

public class NeuralItemHandler
implements IItemHandlerModifiable {
    private final ItemStack stack;

    public NeuralItemHandler(ItemStack stack) {
        this.stack = stack;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public int getSlots() {
        return 10;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot < 5) {
            return stack.hasCapability(Constants.PERIPHERAL_HANDLER_CAPABILITY, null) || stack.hasCapability(Constants.PERIPHERAL_CAPABILITY, null);
        }
        return stack.hasCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        NBTTagCompound tag = ItemBase.getTag(this.stack);
        NBTTagCompound items = NeuralItemHandler.getItems(tag);
        if (stack.func_190926_b()) {
            items.func_82580_o("item" + slot);
        } else {
            items.func_74782_a("item" + slot, (NBTBase)stack.serializeNBT());
        }
        tag.func_74777_a("dirty", (short)(tag.func_74765_d("dirty") | 1 << slot));
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        NBTTagCompound tag = ItemBase.getTag(this.stack);
        NBTTagCompound items = NeuralItemHandler.getItems(tag);
        return items.func_150297_b("item" + slot, 10) ? new ItemStack(items.func_74775_l("item" + slot)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || !this.getStackInSlot(slot).func_190926_b()) {
            return stack;
        }
        return this.isItemValid(slot, stack) ? this.doInsert(slot, stack, simulate) : stack;
    }

    @Nonnull
    private ItemStack doInsert(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getSlotLimit(slot);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                this.setStackInSlot(slot, existing);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    private static NBTTagCompound getItems(NBTTagCompound tag) {
        NBTTagCompound items;
        if (tag.func_150297_b("items", 10)) {
            items = tag.func_74775_l("items");
        } else {
            items = new NBTTagCompound();
            tag.func_74782_a("items", (NBTBase)items);
        }
        return items;
    }
}

