/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeTupleGenerator {
    public static final RecipeTupleGenerator INSTANCE = new RecipeTupleGenerator();
    private boolean itemEnd;
    private boolean fluidEnd;

    private RecipeTupleGenerator() {
    }

    public void generateMaterialListTuples(List<Pair<List<ItemStack>, List<FluidStack>>> tuples, int[] maxNumbers, int[] inputNumbers, List<List<ItemStack>> itemInputLists, List<List<FluidStack>> fluidInputLists) {
        do {
            this.generateNextMaterialListTuple(tuples, maxNumbers, inputNumbers, itemInputLists, fluidInputLists);
        } while (!this.itemEnd || !this.fluidEnd);
    }

    private void generateNextMaterialListTuple(List<Pair<List<ItemStack>, List<FluidStack>>> tuples, int[] maxNumbers, int[] inputNumbers, List<List<ItemStack>> itemInputLists, List<List<FluidStack>> fluidInputLists) {
        int i;
        int itemInputSize = itemInputLists.size();
        int fluidInputSize = fluidInputLists.size();
        ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
        for (i = 0; i < itemInputSize; ++i) {
            itemInputs.add(itemInputLists.get(i).get(inputNumbers[i]));
        }
        for (i = 0; i < fluidInputSize; ++i) {
            fluidInputs.add(fluidInputLists.get(i).get(inputNumbers[i + itemInputSize]));
        }
        tuples.add((Pair<List<ItemStack>, List<FluidStack>>)Pair.of(itemInputs, fluidInputs));
        this.itemEnd = false;
        if (itemInputSize == 0) {
            this.itemEnd = true;
        } else {
            for (i = 0; i < itemInputSize; ++i) {
                if (inputNumbers[i] < maxNumbers[i]) {
                    int n = i;
                    inputNumbers[n] = inputNumbers[n] + 1;
                    break;
                }
                inputNumbers[i] = 0;
                if (i != itemInputSize - 1) continue;
                this.itemEnd = true;
            }
        }
        this.fluidEnd = false;
        if (fluidInputSize == 0) {
            this.fluidEnd = true;
        } else if (this.itemEnd) {
            for (i = 0; i < fluidInputSize; ++i) {
                if (inputNumbers[i + itemInputSize] < maxNumbers[i + itemInputSize]) {
                    int n = i + itemInputSize;
                    inputNumbers[n] = inputNumbers[n] + 1;
                    break;
                }
                inputNumbers[i + itemInputSize] = 0;
                if (i != fluidInputSize - 1) continue;
                this.fluidEnd = true;
            }
        }
    }
}

