/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LogEntry
extends Comparable<LogEntry> {
    public long getTimestamp();

    public @NonNull UUID getActor();

    public @NonNull String getActorName();

    public @NonNull Type getType();

    public @NonNull Optional<UUID> getActed();

    public @NonNull String getActedName();

    public @NonNull String getAction();

    public static interface Builder {
        public @NonNull Builder setTimestamp(long var1);

        public @NonNull Builder setActor(@NonNull UUID var1);

        public @NonNull Builder setActorName(@NonNull String var1);

        public @NonNull Builder setType(@NonNull Type var1);

        public @NonNull Builder setActed(@Nullable UUID var1);

        public @NonNull Builder setActedName(@NonNull String var1);

        public @NonNull Builder setAction(@NonNull String var1);

        public @NonNull LogEntry build();
    }

    public static enum Type {
        USER('U'),
        GROUP('G'),
        TRACK('T');

        private final char code;

        public static @NonNull Type valueOf(char code) {
            switch (code) {
                case 'U': 
                case 'u': {
                    return USER;
                }
                case 'G': 
                case 'g': {
                    return GROUP;
                }
                case 'T': 
                case 't': {
                    return TRACK;
                }
            }
            throw new IllegalArgumentException("Unknown code: " + code);
        }

        private Type(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }
    }
}

