/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExtendedLogEntry
implements LogEntry {
    private static final Comparator<LogEntry> COMPARATOR = Comparator.comparingLong(LogEntry::getTimestamp).thenComparing(LogEntry::getActor).thenComparing(LogEntry::getActorName, String.CASE_INSENSITIVE_ORDER).thenComparing(LogEntry::getType).thenComparing(e -> e.getActed().map(UUID::toString).orElse("")).thenComparing(LogEntry::getActedName, String.CASE_INSENSITIVE_ORDER).thenComparing(LogEntry::getAction);
    private final long timestamp;
    private final UUID actor;
    private final String actorName;
    private final LogEntry.Type type;
    private final UUID acted;
    private final String actedName;
    private final String action;

    public static Builder build() {
        return new Builder();
    }

    private ExtendedLogEntry(long timestamp, UUID actor, String actorName, LogEntry.Type type, UUID acted, String actedName, String action) {
        this.timestamp = timestamp;
        this.actor = actor;
        this.actorName = actorName;
        this.type = type;
        this.acted = acted;
        this.actedName = actedName;
        this.action = action;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public @NonNull UUID getActor() {
        return this.actor;
    }

    @Override
    public @NonNull String getActorName() {
        return this.actorName;
    }

    public String getActorFriendlyString() {
        if (Strings.isNullOrEmpty((String)this.actorName) || this.actorName.equals("null")) {
            return this.actor.toString();
        }
        return this.actorName;
    }

    @Override
    public @NonNull LogEntry.Type getType() {
        return this.type;
    }

    @Override
    public @NonNull Optional<UUID> getActed() {
        return Optional.ofNullable(this.acted);
    }

    @Override
    public @NonNull String getActedName() {
        return this.actedName;
    }

    public String getActedFriendlyString() {
        if ((Strings.isNullOrEmpty((String)this.actedName) || this.actedName.equals("null")) && this.acted != null) {
            return this.acted.toString();
        }
        return String.valueOf(this.actedName);
    }

    @Override
    public @NonNull String getAction() {
        return this.action;
    }

    @Override
    public int compareTo(@NonNull LogEntry other) {
        Objects.requireNonNull(other, "other");
        return COMPARATOR.compare(this, other);
    }

    public boolean matchesSearch(String query) {
        query = Objects.requireNonNull(query, "query").toLowerCase();
        return this.actorName.toLowerCase().contains(query) || this.actedName.toLowerCase().contains(query) || this.action.toLowerCase().contains(query);
    }

    public void submit(LuckPermsPlugin plugin, Sender sender) {
        plugin.getLogDispatcher().dispatch(this, sender);
    }

    public String toString() {
        return "LogEntry(timestamp=" + this.getTimestamp() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", type=" + (Object)((Object)this.getType()) + ", acted=" + this.getActed() + ", actedName=" + this.getActedName() + ", action=" + this.getAction() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry that = (LogEntry)o;
        return this.getTimestamp() == that.getTimestamp() && this.getActor().equals(that.getActor()) && this.getActorName().equals(that.getActorName()) && this.getType() == that.getType() && this.getActed().equals(that.getActed()) && this.getActedName().equals(that.getActedName()) && this.getAction().equals(that.getAction());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (int)(this.getTimestamp() >>> 32 ^ this.getTimestamp());
        result = result * 59 + this.getActor().hashCode();
        result = result * 59 + this.getActorName().hashCode();
        result = result * 59 + this.getType().hashCode();
        result = result * 59 + this.getActed().hashCode();
        result = result * 59 + this.getActedName().hashCode();
        result = result * 59 + this.getAction().hashCode();
        return result;
    }

    public static class Builder
    implements LogEntry.Builder {
        private long timestamp = 0L;
        private UUID actor = null;
        private String actorName = null;
        private LogEntry.Type type = null;
        private UUID acted = null;
        private String actedName = null;
        private String action = null;

        @Override
        public @NonNull Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public @NonNull Builder setActor(@NonNull UUID actor) {
            this.actor = Objects.requireNonNull(actor, "actor");
            return this;
        }

        @Override
        public @NonNull Builder setActorName(@NonNull String actorName) {
            this.actorName = Objects.requireNonNull(actorName, "actorName");
            return this;
        }

        @Override
        public @NonNull Builder setType(@NonNull LogEntry.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public @NonNull Builder setActed(UUID acted) {
            this.acted = acted;
            return this;
        }

        @Override
        public @NonNull Builder setActedName(@NonNull String actedName) {
            this.actedName = Objects.requireNonNull(actedName, "actedName");
            return this;
        }

        @Override
        public @NonNull Builder setAction(@NonNull String action) {
            this.action = Objects.requireNonNull(action, "action");
            return this;
        }

        public Builder timestamp(long timestamp) {
            return this.setTimestamp(timestamp);
        }

        public Builder actor(UUID actor) {
            return this.setActor(actor);
        }

        public Builder actorName(String actorName) {
            return this.setActorName(actorName);
        }

        public Builder type(LogEntry.Type type) {
            return this.setType(type);
        }

        public Builder acted(UUID acted) {
            return this.setActed(acted);
        }

        public Builder actedName(String actedName) {
            return this.setActedName(actedName);
        }

        public Builder action(String action) {
            return this.setAction(action);
        }

        public Builder actor(Sender actor) {
            this.actorName(actor.getNameWithLocation());
            this.actor(actor.getUuid());
            return this;
        }

        public Builder acted(PermissionHolder acted) {
            if (acted.getType().isUser()) {
                this.actedName(((User)acted).getName().orElse("null"));
                this.acted(((User)acted).getUuid());
                this.type(LogEntry.Type.USER);
            } else if (acted.getType().isGroup()) {
                this.actedName(((Group)acted).getName());
                this.type(LogEntry.Type.GROUP);
            }
            return this;
        }

        public Builder acted(Track track) {
            this.actedName(track.getName());
            this.type(LogEntry.Type.TRACK);
            return this;
        }

        public Builder action(Object ... args) {
            ArrayList<String> parts = new ArrayList<String>();
            for (Object o : args) {
                if (o instanceof ContextSet) {
                    ContextSet set = (ContextSet)o;
                    for (String string : set.getValues("server")) {
                        parts.add("server=" + string);
                    }
                    for (String string : set.getValues("world")) {
                        parts.add("world=" + string);
                    }
                    for (Map.Entry entry : set.toSet()) {
                        if (((String)entry.getKey()).equals("server") || ((String)entry.getKey()).equals("world")) continue;
                        parts.add((String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    continue;
                }
                parts.add(String.valueOf(o));
            }
            this.action(parts.stream().collect(Collectors.joining(" ")));
            return this;
        }

        @Override
        public @NonNull ExtendedLogEntry build() {
            if (this.timestamp == 0L) {
                this.timestamp(System.currentTimeMillis() / 1000L);
            }
            Objects.requireNonNull(this.actor, "actor");
            Objects.requireNonNull(this.actorName, "actorName");
            Objects.requireNonNull(this.type, "type");
            Objects.requireNonNull(this.actedName, "actedName");
            Objects.requireNonNull(this.action, "action");
            return new ExtendedLogEntry(this.timestamp, this.actor, this.actorName, this.type, this.acted, this.actedName, this.action);
        }

        public String toString() {
            return "ExtendedLogEntry.Builder(timestamp=" + this.timestamp + ", actor=" + this.actor + ", actorName=" + this.actorName + ", type=" + (Object)((Object)this.type) + ", acted=" + this.acted + ", actedName=" + this.actedName + ", action=" + this.action + ")";
        }
    }
}

