/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.OptionalInt;
import me.lucko.luckperms.api.caching.GroupData;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.api.delegates.model.ApiPermissionHolder;
import me.lucko.luckperms.common.model.Group;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ApiGroup
extends ApiPermissionHolder
implements me.lucko.luckperms.api.Group {
    private final Group handle;

    public static Group cast(me.lucko.luckperms.api.Group group) {
        Objects.requireNonNull(group, "group");
        Preconditions.checkState((boolean)(group instanceof ApiGroup), (Object)("Illegal instance " + group.getClass() + " cannot be handled by this implementation."));
        return ((ApiGroup)group).getHandle();
    }

    public ApiGroup(Group handle) {
        super(handle);
        this.handle = handle;
    }

    @Override
    Group getHandle() {
        return this.handle;
    }

    @Override
    public @NonNull String getName() {
        return this.handle.getName();
    }

    @Override
    public @Nullable String getDisplayName() {
        return this.handle.getDisplayName().orElse(null);
    }

    @Override
    public @Nullable String getDisplayName(@NonNull ContextSet contextSet) {
        return this.handle.getDisplayName(contextSet).orElse(null);
    }

    @Override
    public @NonNull OptionalInt getWeight() {
        return this.handle.getWeight();
    }

    @Override
    public @NonNull GroupData getCachedData() {
        return this.handle.getCachedData();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiGroup)) {
            return false;
        }
        ApiGroup that = (ApiGroup)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

