/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.model;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.DemotionResult;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.PromotionResult;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.api.delegates.model.ApiGroup;
import me.lucko.luckperms.common.api.delegates.model.ApiUser;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.utils.Predicates;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ApiTrack
implements me.lucko.luckperms.api.Track {
    private final Track handle;

    public static Track cast(me.lucko.luckperms.api.Track track) {
        Objects.requireNonNull(track, "track");
        Preconditions.checkState((boolean)(track instanceof ApiTrack), (Object)("Illegal instance " + track.getClass() + " cannot be handled by this implementation."));
        return ((ApiTrack)track).getHandle();
    }

    public ApiTrack(Track handle) {
        this.handle = handle;
    }

    Track getHandle() {
        return this.handle;
    }

    @Override
    public @NonNull String getName() {
        return this.handle.getName();
    }

    @Override
    public @NonNull List<String> getGroups() {
        return this.handle.getGroups();
    }

    @Override
    public int getSize() {
        return this.handle.getSize();
    }

    @Override
    public String getNext(@NonNull Group current) {
        Objects.requireNonNull(current, "current");
        try {
            return this.handle.getNext(ApiGroup.cast(current));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getPrevious(@NonNull Group current) {
        Objects.requireNonNull(current, "current");
        try {
            return this.handle.getPrevious(ApiGroup.cast(current));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public @NonNull PromotionResult promote(@NonNull User user, @NonNull ContextSet contextSet) {
        return this.handle.promote(ApiUser.cast(user), contextSet, Predicates.alwaysTrue(), null, true);
    }

    @Override
    public @NonNull DemotionResult demote(@NonNull User user, @NonNull ContextSet contextSet) {
        return this.handle.demote(ApiUser.cast(user), contextSet, Predicates.alwaysTrue(), null, true);
    }

    @Override
    public @NonNull DataMutateResult appendGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        return this.handle.appendGroup(ApiGroup.cast(group));
    }

    @Override
    public @NonNull DataMutateResult insertGroup(@NonNull Group group, int position) throws IndexOutOfBoundsException {
        Objects.requireNonNull(group, "group");
        return this.handle.insertGroup(ApiGroup.cast(group), position);
    }

    @Override
    public @NonNull DataMutateResult removeGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        return this.handle.removeGroup(ApiGroup.cast(group));
    }

    @Override
    public @NonNull DataMutateResult removeGroup(@NonNull String group) {
        Objects.requireNonNull(group, "group");
        return this.handle.removeGroup(group);
    }

    @Override
    public boolean containsGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        return this.handle.containsGroup(ApiGroup.cast(group));
    }

    @Override
    public boolean containsGroup(@NonNull String group) {
        Objects.requireNonNull(group, "group");
        return this.handle.containsGroup(group);
    }

    @Override
    public void clearGroups() {
        this.handle.clearGroups();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiTrack)) {
            return false;
        }
        ApiTrack that = (ApiTrack)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

