/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.backup;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.Storage;
import me.lucko.luckperms.common.utils.ProgressLogger;

public class Exporter
implements Runnable {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final LuckPermsPlugin plugin;
    private final Sender executor;
    private final Path filePath;
    private final boolean includeUsers;
    private final ProgressLogger log;

    private static void write(BufferedWriter writer, String s) {
        try {
            writer.write(s);
            writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Exporter(LuckPermsPlugin plugin, Sender executor, Path filePath, boolean includeUsers) {
        this.plugin = plugin;
        this.executor = executor;
        this.filePath = filePath;
        this.includeUsers = includeUsers;
        this.log = new ProgressLogger(null, Message.EXPORT_LOG, Message.EXPORT_LOG_PROGRESS);
        this.log.addListener(plugin.getConsoleSender());
        this.log.addListener(executor);
    }

    @Override
    public void run() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.log.log("Starting.");
            Exporter.write(writer, "# LuckPerms Export File");
            Exporter.write(writer, "# Generated by " + this.executor.getNameWithLocation() + " at " + DATE_FORMAT.format(new Date(System.currentTimeMillis())));
            Exporter.write(writer, "");
            this.log.log("Starting group export.");
            Exporter.write(writer, "# Create groups");
            AtomicInteger groupCount = new AtomicInteger(0);
            List groups = this.plugin.getGroupManager().getAll().values().stream().sorted((o1, o2) -> {
                int i = Integer.compare(o2.getWeight().orElse(0), o1.getWeight().orElse(0));
                return i != 0 ? i : o1.getName().compareToIgnoreCase(o2.getName());
            }).collect(Collectors.toList());
            for (Object group : groups) {
                if (((Group)group).getName().equals("default")) continue;
                Exporter.write(writer, "/lp creategroup " + ((Group)group).getName());
            }
            for (Object group : groups) {
                if (groupCount.get() == 0) {
                    Exporter.write(writer, "");
                }
                Exporter.write(writer, "# Export group: " + ((Group)group).getName());
                for (Node node : ((PermissionHolder)group).enduringData().immutable().values()) {
                    Exporter.write(writer, "/lp " + NodeFactory.nodeAsCommand(node, ((Group)group).getName(), HolderType.GROUP, true, false));
                }
                Exporter.write(writer, "");
                this.log.logAllProgress("Exported {} groups so far.", groupCount.incrementAndGet());
            }
            this.log.log("Exported " + groupCount.get() + " groups.");
            Exporter.write(writer, "");
            Exporter.write(writer, "");
            this.log.log("Starting track export.");
            Collection tracks = this.plugin.getTrackManager().getAll().values();
            if (!tracks.isEmpty()) {
                Exporter.write(writer, "# Create tracks");
                for (Object track : tracks) {
                    Exporter.write(writer, "/lp createtrack " + ((Track)track).getName());
                }
                Exporter.write(writer, "");
                AtomicInteger trackCount = new AtomicInteger(0);
                for (Track track : this.plugin.getTrackManager().getAll().values()) {
                    Exporter.write(writer, "# Export track: " + track.getName());
                    for (String group : track.getGroups()) {
                        Exporter.write(writer, "/lp track " + track.getName() + " append " + group);
                    }
                    Exporter.write(writer, "");
                    this.log.logAllProgress("Exported {} tracks so far.", trackCount.incrementAndGet());
                }
                Exporter.write(writer, "");
                Exporter.write(writer, "");
            }
            this.log.log("Exported " + tracks.size() + " tracks.");
            if (this.includeUsers) {
                this.log.log("Starting user export. Finding a list of unique users to export.");
                Storage ds = this.plugin.getStorage();
                Set<UUID> users = ds.getUniqueUsers().join();
                this.log.log("Found " + users.size() + " unique users to export.");
                Exporter.write(writer, "# Export users");
                ExecutorService executor = Executors.newFixedThreadPool(32);
                ReentrantLock lock = new ReentrantLock();
                Consumer<List> writeFunction = strings -> {
                    lock.lock();
                    try {
                        for (String s : strings) {
                            Exporter.write(writer, s);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                };
                HashSet<CompletableFuture<Void>> futures = new HashSet<CompletableFuture<Void>>();
                AtomicInteger userCount = new AtomicInteger(0);
                for (UUID uuid : users) {
                    futures.add(CompletableFuture.runAsync(() -> {
                        ArrayList<String> output = new ArrayList<String>();
                        User user = this.plugin.getStorage().loadUser(uuid, null).join();
                        output.add("# Export user: " + user.getUuid().toString() + " - " + user.getName().orElse("unknown username"));
                        boolean inDefault = false;
                        for (Node node : user.enduringData().immutable().values()) {
                            if (node.isGroupNode() && node.getGroupName().equalsIgnoreCase("default")) {
                                inDefault = true;
                                continue;
                            }
                            output.add("/lp " + NodeFactory.nodeAsCommand(node, user.getUuid().toString(), HolderType.USER, true, false));
                        }
                        if (!user.getPrimaryGroup().getStoredValue().orElse("default").equalsIgnoreCase("default")) {
                            output.add("/lp user " + user.getUuid().toString() + " switchprimarygroup " + user.getPrimaryGroup().getStoredValue().get());
                        }
                        if (!inDefault) {
                            output.add("/lp user " + user.getUuid().toString() + " parent remove default");
                        }
                        this.plugin.getUserManager().cleanup(user);
                        writeFunction.accept(output);
                        userCount.incrementAndGet();
                    }, executor));
                }
                CompletableFuture<Void> overallFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                while (true) {
                    try {
                        overallFuture.get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        this.log.logAllProgress("Exported {} users so far.", userCount.get());
                        continue;
                    }
                    break;
                }
                executor.shutdown();
                this.log.log("Exported " + userCount.get() + " users.");
            }
            writer.flush();
            this.log.getListeners().forEach(l -> Message.LOG_EXPORT_SUCCESS.send((Sender)l, this.filePath.toFile().getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

