/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.buffers;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ExpiringCache<T>
implements Supplier<T> {
    private final long durationNanos;
    private volatile T value;
    private volatile long expirationNanos;

    protected ExpiringCache(long duration, TimeUnit unit) {
        this.durationNanos = unit.toNanos(duration);
    }

    protected abstract @NonNull T supply();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long nanos = this.expirationNanos;
        long now = System.nanoTime();
        if (nanos == 0L || now - nanos >= 0L) {
            ExpiringCache expiringCache = this;
            synchronized (expiringCache) {
                if (nanos == this.expirationNanos) {
                    T t = this.supply();
                    this.value = t;
                    nanos = now + this.durationNanos;
                    this.expirationNanos = nanos == 0L ? 1L : nanos;
                    return t;
                }
            }
        }
        return this.value;
    }

    public void invalidate() {
        this.expirationNanos = 0L;
    }
}

