/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate.action;

import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.action.Action;
import me.lucko.luckperms.common.bulkupdate.query.QueryField;
import me.lucko.luckperms.common.node.model.NodeDataContainer;

public class UpdateAction
implements Action {
    private final QueryField field;
    private final String value;

    public static UpdateAction of(QueryField field, String value) {
        return new UpdateAction(field, value);
    }

    private UpdateAction(QueryField field, String value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public String getName() {
        return "update";
    }

    @Override
    public NodeDataContainer apply(NodeDataContainer from) {
        switch (this.field) {
            case PERMISSION: {
                return from.setPermission(this.value);
            }
            case SERVER: {
                return from.setServer(this.value);
            }
            case WORLD: {
                return from.setWorld(this.value);
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void appendSql(PreparedStatementBuilder builder) {
        builder.append("UPDATE {table} SET " + this.field.getSqlName() + "=?");
        builder.variable(this.value);
    }
}

