/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.caching;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.caching.CachedData;
import me.lucko.luckperms.api.caching.MetaContexts;
import me.lucko.luckperms.common.caching.type.MetaAccumulator;
import me.lucko.luckperms.common.caching.type.MetaCache;
import me.lucko.luckperms.common.caching.type.PermissionCache;
import me.lucko.luckperms.common.calculators.CalculatorFactory;
import me.lucko.luckperms.common.calculators.PermissionCalculatorMetadata;
import me.lucko.luckperms.common.metastacking.SimpleMetaStack;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.caffeine.cache.AsyncLoadingCache;
import me.lucko.luckperms.lib.caffeine.cache.CacheLoader;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCachedData
implements CachedData {
    protected final LuckPermsPlugin plugin;
    private final AsyncLoadingCache<Contexts, PermissionCache> permission = Caffeine.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).buildAsync((CacheLoader)new PermissionCacheLoader());
    private final AsyncLoadingCache<MetaContexts, MetaCache> meta = Caffeine.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).buildAsync((CacheLoader)new MetaCacheLoader());

    public AbstractCachedData(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    protected abstract PermissionCalculatorMetadata getMetadataForContexts(Contexts var1);

    protected abstract CalculatorFactory getCalculatorFactory();

    protected abstract MetaContexts getDefaultMetaContexts(Contexts var1);

    protected abstract Map<String, Boolean> resolvePermissions();

    protected abstract Map<String, Boolean> resolvePermissions(Contexts var1);

    protected abstract void resolveMeta(MetaAccumulator var1);

    protected abstract void resolveMeta(MetaAccumulator var1, MetaContexts var2);

    private PermissionCache calculatePermissions(Contexts contexts, PermissionCache data) {
        Objects.requireNonNull(contexts, "contexts");
        if (data == null) {
            PermissionCalculatorMetadata metadata = this.getMetadataForContexts(contexts);
            data = new PermissionCache(contexts, metadata, this.getCalculatorFactory());
        }
        if (contexts == Contexts.allowAll()) {
            data.setPermissions(this.resolvePermissions());
        } else {
            data.setPermissions(this.resolvePermissions(contexts));
        }
        return data;
    }

    private MetaCache calculateMeta(MetaContexts contexts, MetaCache data) {
        Objects.requireNonNull(contexts, "contexts");
        if (data == null) {
            data = new MetaCache(contexts);
        }
        MetaAccumulator accumulator = AbstractCachedData.newAccumulator(contexts);
        if (contexts.getContexts() == Contexts.allowAll()) {
            this.resolveMeta(accumulator);
        } else {
            this.resolveMeta(accumulator, contexts);
        }
        data.loadMeta(accumulator);
        return data;
    }

    @Override
    public final @NonNull PermissionCache getPermissionData(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return (PermissionCache)this.permission.synchronous().get((Object)contexts);
    }

    @Override
    public final @NonNull MetaCache getMetaData(@NonNull MetaContexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return (MetaCache)this.meta.synchronous().get((Object)contexts);
    }

    @Override
    public final @NonNull MetaCache getMetaData(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return this.getMetaData(this.getDefaultMetaContexts(contexts));
    }

    @Override
    public final @NonNull PermissionCache calculatePermissions(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return this.calculatePermissions(contexts, null);
    }

    @Override
    public final @NonNull MetaCache calculateMeta(@NonNull MetaContexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return this.calculateMeta(contexts, null);
    }

    @Override
    public final @NonNull MetaCache calculateMeta(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return this.calculateMeta(this.getDefaultMetaContexts(contexts));
    }

    @Override
    public final void recalculatePermissions(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.permission.synchronous().refresh((Object)contexts);
    }

    @Override
    public final void recalculateMeta(@NonNull MetaContexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.meta.synchronous().refresh((Object)contexts);
    }

    @Override
    public final void recalculateMeta(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.recalculateMeta(this.getDefaultMetaContexts(contexts));
    }

    public final @NonNull CompletableFuture<PermissionCache> reloadPermissions(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        CompletableFuture previous = this.permission.getIfPresent((Object)contexts);
        this.permission.synchronous().invalidate((Object)contexts);
        PermissionCache value = (PermissionCache)AbstractCachedData.getIfReady(previous);
        if (value != null) {
            return this.permission.get((Object)contexts, c -> this.calculatePermissions((Contexts)c, value));
        }
        return this.permission.get((Object)contexts);
    }

    public final @NonNull CompletableFuture<MetaCache> reloadMeta(@NonNull MetaContexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        CompletableFuture previous = this.meta.getIfPresent((Object)contexts);
        this.meta.synchronous().invalidate((Object)contexts);
        MetaCache value = (MetaCache)AbstractCachedData.getIfReady(previous);
        if (value != null) {
            return this.meta.get((Object)contexts, c -> this.calculateMeta((MetaContexts)c, value));
        }
        return this.meta.get((Object)contexts);
    }

    public final @NonNull CompletableFuture<MetaCache> reloadMeta(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return this.reloadMeta(this.getDefaultMetaContexts(contexts));
    }

    @Override
    public final void recalculatePermissions() {
        Set keys = this.permission.synchronous().asMap().keySet();
        keys.forEach(this::recalculatePermissions);
    }

    @Override
    public final void recalculateMeta() {
        Set keys = this.meta.synchronous().asMap().keySet();
        keys.forEach(this::recalculateMeta);
    }

    @Override
    public final @NonNull CompletableFuture<Void> reloadPermissions() {
        Set keys = this.permission.synchronous().asMap().keySet();
        return CompletableFuture.allOf((CompletableFuture[])keys.stream().map(this::reloadPermissions).toArray(CompletableFuture[]::new));
    }

    @Override
    public final @NonNull CompletableFuture<Void> reloadMeta() {
        Set keys = this.meta.synchronous().asMap().keySet();
        return CompletableFuture.allOf((CompletableFuture[])keys.stream().map(this::reloadMeta).toArray(CompletableFuture[]::new));
    }

    @Override
    public final void invalidatePermissions(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.permission.synchronous().invalidate((Object)contexts);
    }

    @Override
    public final void invalidateMeta(@NonNull MetaContexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.meta.synchronous().invalidate((Object)contexts);
    }

    @Override
    public final void invalidateMeta(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.meta.synchronous().invalidate((Object)this.getDefaultMetaContexts(contexts));
    }

    @Override
    public final void invalidatePermissions() {
        this.permission.synchronous().invalidateAll();
    }

    @Override
    public final void invalidateMeta() {
        this.meta.synchronous().invalidateAll();
    }

    @Override
    public final void invalidatePermissionCalculators() {
        this.permission.synchronous().asMap().values().forEach(PermissionCache::invalidateCache);
    }

    public final void invalidate() {
        this.invalidatePermissions();
        this.invalidateMeta();
    }

    public final void doCacheCleanup() {
        this.permission.synchronous().cleanUp();
        this.meta.synchronous().cleanUp();
    }

    private static boolean isReady(@Nullable CompletableFuture<?> future) {
        return future != null && future.isDone() && !future.isCompletedExceptionally() && future.join() != null;
    }

    private static <V> V getIfReady(@Nullable CompletableFuture<V> future) {
        return AbstractCachedData.isReady(future) ? (V)future.join() : null;
    }

    private static MetaAccumulator newAccumulator(MetaContexts contexts) {
        return new MetaAccumulator(new SimpleMetaStack(contexts.getPrefixStackDefinition(), ChatMetaType.PREFIX), new SimpleMetaStack(contexts.getSuffixStackDefinition(), ChatMetaType.SUFFIX));
    }

    private final class MetaCacheLoader
    implements CacheLoader<MetaContexts, MetaCache> {
        private MetaCacheLoader() {
        }

        public MetaCache load(@NonNull MetaContexts contexts) {
            return AbstractCachedData.this.calculateMeta(contexts);
        }

        public MetaCache reload(@NonNull MetaContexts contexts, @NonNull MetaCache oldData) {
            return AbstractCachedData.this.calculateMeta(contexts, oldData);
        }
    }

    private final class PermissionCacheLoader
    implements CacheLoader<Contexts, PermissionCache> {
        private PermissionCacheLoader() {
        }

        public PermissionCache load(@NonNull Contexts contexts) {
            return AbstractCachedData.this.calculatePermissions(contexts);
        }

        public PermissionCache reload(@NonNull Contexts contexts, @NonNull PermissionCache oldData) {
            return AbstractCachedData.this.calculatePermissions(contexts, oldData);
        }
    }
}

