/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.caching.type;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.nodetype.types.MetaType;
import me.lucko.luckperms.api.nodetype.types.PrefixType;
import me.lucko.luckperms.api.nodetype.types.SuffixType;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.metastacking.MetaStack;
import me.lucko.luckperms.common.metastacking.SimpleMetaStack;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class MetaAccumulator {
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACCUMULATING);
    private final ListMultimap<String, String> meta;
    private final SortedMap<Integer, String> prefixes;
    private final SortedMap<Integer, String> suffixes;
    private int weight = 0;
    private final MetaStack prefixStack;
    private final MetaStack suffixStack;

    public static MetaAccumulator makeFromConfig(LuckPermsPlugin plugin) {
        return new MetaAccumulator(new SimpleMetaStack(plugin.getConfiguration().get(ConfigKeys.PREFIX_FORMATTING_OPTIONS), ChatMetaType.PREFIX), new SimpleMetaStack(plugin.getConfiguration().get(ConfigKeys.SUFFIX_FORMATTING_OPTIONS), ChatMetaType.SUFFIX));
    }

    public MetaAccumulator(MetaStack prefixStack, MetaStack suffixStack) {
        Objects.requireNonNull(prefixStack, "prefixStack");
        Objects.requireNonNull(suffixStack, "suffixStack");
        this.meta = ArrayListMultimap.create();
        this.prefixes = new TreeMap(Comparator.reverseOrder());
        this.suffixes = new TreeMap(Comparator.reverseOrder());
        this.prefixStack = prefixStack;
        this.suffixStack = suffixStack;
    }

    private void ensureState(State state) {
        if (this.state.get() != state) {
            throw new IllegalStateException("State must be " + (Object)((Object)state) + ", but is actually " + (Object)((Object)this.state.get()));
        }
    }

    public void complete() {
        if (!this.state.compareAndSet(State.ACCUMULATING, State.COMPLETE)) {
            return;
        }
        if (!this.meta.containsKey((Object)"weight") && this.weight != 0) {
            this.meta.put((Object)"weight", (Object)String.valueOf(this.weight));
        }
    }

    public void accumulateNode(LocalizedNode n) {
        this.ensureState(State.ACCUMULATING);
        n.getTypeData(MetaType.KEY).ifPresent(metaType -> this.meta.put((Object)metaType.getKey(), (Object)metaType.getValue()));
        n.getTypeData(PrefixType.KEY).ifPresent(prefix -> {
            this.prefixes.putIfAbsent(prefix.getPriority(), prefix.getPrefix());
            this.prefixStack.accumulateToAll(n);
        });
        n.getTypeData(SuffixType.KEY).ifPresent(suffix -> {
            this.suffixes.putIfAbsent(suffix.getPriority(), suffix.getSuffix());
            this.suffixStack.accumulateToAll(n);
        });
    }

    public void accumulateMeta(String key, String value) {
        this.ensureState(State.ACCUMULATING);
        this.meta.put((Object)key, (Object)value);
    }

    public void accumulateWeight(int weight) {
        this.ensureState(State.ACCUMULATING);
        this.weight = Math.max(this.weight, weight);
    }

    public ListMultimap<String, String> getMeta() {
        this.ensureState(State.COMPLETE);
        return this.meta;
    }

    public Map<Integer, String> getChatMeta(ChatMetaType type) {
        this.ensureState(State.COMPLETE);
        return type == ChatMetaType.PREFIX ? this.prefixes : this.suffixes;
    }

    public SortedMap<Integer, String> getPrefixes() {
        this.ensureState(State.COMPLETE);
        return this.prefixes;
    }

    public SortedMap<Integer, String> getSuffixes() {
        this.ensureState(State.COMPLETE);
        return this.suffixes;
    }

    public int getWeight() {
        this.ensureState(State.COMPLETE);
        return this.weight;
    }

    public MetaStack getPrefixStack() {
        this.ensureState(State.COMPLETE);
        return this.prefixStack;
    }

    public MetaStack getSuffixStack() {
        this.ensureState(State.COMPLETE);
        return this.suffixStack;
    }

    public String toString() {
        return "MetaAccumulator(meta=" + this.meta + ", prefixes=" + this.prefixes + ", suffixes=" + this.suffixes + ", weight=" + this.weight + ", prefixStack=" + this.prefixStack + ", suffixStack=" + this.suffixStack + ")";
    }

    private static enum State {
        ACCUMULATING,
        COMPLETE;

    }
}

