/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.caching.type;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.caching.MetaContexts;
import me.lucko.luckperms.api.caching.MetaData;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import me.lucko.luckperms.common.caching.type.MetaAccumulator;
import me.lucko.luckperms.common.metastacking.MetaStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MetaCache
implements MetaData {
    private final MetaContexts metaContexts;
    private ListMultimap<String, String> metaMultimap = ImmutableListMultimap.of();
    private Map<String, String> meta = ImmutableMap.of();
    private SortedMap<Integer, String> prefixes = ImmutableSortedMap.of();
    private SortedMap<Integer, String> suffixes = ImmutableSortedMap.of();
    private MetaStack prefixStack = null;
    private MetaStack suffixStack = null;

    public MetaCache(MetaContexts metaContexts) {
        this.metaContexts = metaContexts;
    }

    public void loadMeta(MetaAccumulator meta) {
        meta.complete();
        this.metaMultimap = ImmutableListMultimap.copyOf(meta.getMeta());
        Map metaMap = this.metaMultimap.asMap();
        ImmutableMap.Builder metaMapBuilder = ImmutableMap.builder();
        for (Map.Entry e : metaMap.entrySet()) {
            if (((List)e.getValue()).isEmpty()) continue;
            metaMapBuilder.put(e.getKey(), ((List)e.getValue()).get(0));
        }
        this.meta = metaMapBuilder.build();
        this.prefixes = ImmutableSortedMap.copyOfSorted(meta.getPrefixes());
        this.suffixes = ImmutableSortedMap.copyOfSorted(meta.getSuffixes());
        this.prefixStack = meta.getPrefixStack();
        this.suffixStack = meta.getSuffixStack();
    }

    @Override
    public String getPrefix() {
        MetaStack prefixStack = this.prefixStack;
        return prefixStack == null ? null : prefixStack.toFormattedString();
    }

    @Override
    public String getSuffix() {
        MetaStack suffixStack = this.suffixStack;
        return suffixStack == null ? null : suffixStack.toFormattedString();
    }

    @Override
    public @NonNull MetaStackDefinition getPrefixStackDefinition() {
        return this.prefixStack.getDefinition();
    }

    @Override
    public @NonNull MetaStackDefinition getSuffixStackDefinition() {
        return this.suffixStack.getDefinition();
    }

    @Override
    public @NonNull Contexts getContexts() {
        return this.metaContexts.getContexts();
    }

    @Override
    public @NonNull MetaContexts getMetaContexts() {
        return this.metaContexts;
    }

    @Override
    public @NonNull ListMultimap<String, String> getMetaMultimap() {
        return this.metaMultimap;
    }

    @Override
    public @NonNull Map<String, String> getMeta() {
        return this.meta;
    }

    @Override
    public @NonNull SortedMap<Integer, String> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public @NonNull SortedMap<Integer, String> getSuffixes() {
        return this.suffixes;
    }
}

