/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.tabcomplete;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.treeview.PermissionRegistry;
import me.lucko.luckperms.common.treeview.TreeNode;

public final class TabCompletions {
    private static final CompletionSupplier BOOLEAN = CompletionSupplier.startsWith("true", "false");
    private final CompletionSupplier groups = CompletionSupplier.startsWith(() -> plugin.getGroupManager().getAll().keySet());
    private final CompletionSupplier tracks = CompletionSupplier.startsWith(() -> plugin.getTrackManager().getAll().keySet());
    private final CompletionSupplier permissions = partial -> {
        PermissionRegistry cache = plugin.getPermissionRegistry();
        if (partial.isEmpty()) {
            return cache.getRootNode().getChildren().map(Map::keySet).map(ArrayList::new).orElse(Collections.emptyList());
        }
        String start = partial.toLowerCase();
        ArrayList parts = new ArrayList(Splitter.on((char)'.').splitToList((CharSequence)start));
        TreeNode root = cache.getRootNode();
        if (parts.size() <= 1) {
            if (!root.getChildren().isPresent()) {
                return Collections.emptyList();
            }
            return root.getChildren().get().keySet().stream().filter(TabCompleter.startsWithIgnoreCase(start)).collect(Collectors.toList());
        }
        String incomplete = (String)parts.remove(parts.size() - 1);
        for (String s2 : parts) {
            if (!root.getChildren().isPresent()) {
                return Collections.emptyList();
            }
            TreeNode n = root.getChildren().get().get(s2);
            if (n == null) {
                return Collections.emptyList();
            }
            root = n;
        }
        if (!root.getChildren().isPresent()) {
            return Collections.emptyList();
        }
        return root.getChildren().get().keySet().stream().filter(TabCompleter.startsWithIgnoreCase(incomplete)).map(s -> parts.stream().collect(Collectors.joining(".")) + "." + s).collect(Collectors.toList());
    };

    public TabCompletions(LuckPermsPlugin plugin) {
    }

    public static CompletionSupplier booleans() {
        return BOOLEAN;
    }

    public static CompletionSupplier groups(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().groups;
    }

    public static CompletionSupplier tracks(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().tracks;
    }

    public static CompletionSupplier permissions(LuckPermsPlugin plugin) {
        return plugin.getCommandManager().getTabCompletions().permissions;
    }
}

