/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import java.util.List;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class HolderClear<T extends PermissionHolder>
extends SubCommand<T> {
    public HolderClear(LocaleManager locale, boolean user) {
        super(CommandSpec.HOLDER_CLEAR.localize(locale), "clear", user ? CommandPermission.USER_CLEAR : CommandPermission.GROUP_CLEAR, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T holder, List<String> args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        int before = ((PermissionHolder)holder).enduringData().immutable().size();
        MutableContextSet context = ArgumentParser.parseContext(0, args, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, this.getPermission().get(), context) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        if (context.isEmpty()) {
            ((PermissionHolder)holder).clearNodes();
        } else {
            ((PermissionHolder)holder).clearNodes(context);
        }
        int changed = before - ((PermissionHolder)holder).enduringData().immutable().size();
        if (changed == 1) {
            Message.CLEAR_SUCCESS_SINGULAR.send(sender, ((PermissionHolder)holder).getFormattedDisplayName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context), changed);
        } else {
            Message.CLEAR_SUCCESS.send(sender, ((PermissionHolder)holder).getFormattedDisplayName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context), changed);
        }
        ExtendedLogEntry.build().actor(sender).acted((PermissionHolder)holder).action("clear", context).build().submit(plugin, sender);
        StorageAssistant.save(holder, sender, plugin);
        return CommandResult.SUCCESS;
    }
}

