/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.web.StandardPastebin;
import me.lucko.luckperms.common.web.WebEditor;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class HolderEditor<T extends PermissionHolder>
extends SubCommand<T> {
    public HolderEditor(LocaleManager locale, boolean user) {
        super(CommandSpec.HOLDER_EDITOR.localize(locale), "editor", user ? CommandPermission.USER_EDITOR : CommandPermission.GROUP_EDITOR, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T holder, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)ContextSet.empty())) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message.EDITOR_START.send(sender, new Object[0]);
        JsonObject payload = WebEditor.formPayload(Collections.singletonList(holder), sender, label, plugin);
        String pasteId = StandardPastebin.BYTEBIN.postJson((JsonElement)payload, true).id();
        if (pasteId == null) {
            Message.EDITOR_UPLOAD_FAILURE.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        String url = plugin.getConfiguration().get(ConfigKeys.WEB_EDITOR_URL_PATTERN) + "?" + pasteId;
        Message.EDITOR_URL.send(sender, new Object[0]);
        TextComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)url).color(TextColor.AQUA)).clickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url))).hoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Click to open the editor.").color(TextColor.GRAY)))).build();
        sender.sendMessage((Component)message);
        return CommandResult.SUCCESS;
    }
}

