/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class HolderShowTracks<T extends PermissionHolder>
extends SubCommand<T> {
    public HolderShowTracks(LocaleManager locale, boolean user) {
        super(CommandSpec.HOLDER_SHOWTRACKS.localize(locale), "showtracks", user ? CommandPermission.USER_SHOW_TRACKS : CommandPermission.GROUP_SHOW_TRACKS, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T holder, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        try {
            plugin.getStorage().loadAllTracks().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.TRACKS_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        ArrayList<Map.Entry> lines = new ArrayList<Map.Entry>();
        if (((PermissionHolder)holder).getType().isUser()) {
            Set nodes = ((PermissionHolder)holder).enduringData().immutable().values().stream().filter(Node::isGroupNode).filter(Node::getValue).filter(Node::isPermanent).collect(Collectors.toSet());
            for (Node node : nodes) {
                String groupName = node.getGroupName();
                List tracks = plugin.getTrackManager().getAll().values().stream().filter(t -> t.containsGroup(groupName)).collect(Collectors.toList());
                for (Track t2 : tracks) {
                    lines.add(Maps.immutableEntry((Object)t2, (Object)(MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node) + "\n" + MessageUtils.listToArrowSep(t2.getGroups(), groupName))));
                }
            }
        } else {
            String groupName = ((Group)holder).getName();
            List tracks = plugin.getTrackManager().getAll().values().stream().filter(t -> t.containsGroup(groupName)).collect(Collectors.toList());
            for (Track t3 : tracks) {
                lines.add(Maps.immutableEntry((Object)t3, (Object)MessageUtils.listToArrowSep(t3.getGroups(), groupName)));
            }
        }
        if (lines.isEmpty()) {
            Message.LIST_TRACKS_EMPTY.send(sender, ((PermissionHolder)holder).getFormattedDisplayName());
            return CommandResult.SUCCESS;
        }
        Message.LIST_TRACKS.send(sender, ((PermissionHolder)holder).getFormattedDisplayName());
        for (Map.Entry line : lines) {
            Message.LIST_TRACKS_ENTRY.send(sender, ((Track)line.getKey()).getName(), line.getValue());
        }
        return CommandResult.SUCCESS;
    }
}

