/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class ListGroups
extends SingleCommand {
    public ListGroups(LocaleManager locale) {
        super(CommandSpec.LIST_GROUPS.localize(locale), "ListGroups", CommandPermission.LIST_GROUPS, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        try {
            plugin.getStorage().loadAllGroups().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.GROUPS_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        Message.GROUPS_LIST.send(sender, new Object[0]);
        plugin.getGroupManager().getAll().values().stream().sorted((o1, o2) -> {
            int i = Integer.compare(o2.getWeight().orElse(0), o1.getWeight().orElse(0));
            return i != 0 ? i : o1.getName().compareToIgnoreCase(o2.getName());
        }).forEach(group -> {
            List<String> tracks = plugin.getTrackManager().getAll().values().stream().filter(t -> t.containsGroup((Group)group)).map(Track::getName).collect(Collectors.toList());
            TextComponent component = tracks.isEmpty() ? Message.GROUPS_LIST_ENTRY.asComponent(plugin.getLocaleManager(), group.getFormattedDisplayName(), group.getWeight().orElse(0)) : Message.GROUPS_LIST_ENTRY_WITH_TRACKS.asComponent(plugin.getLocaleManager(), group.getFormattedDisplayName(), group.getWeight().orElse(0), MessageUtils.toCommaSep(tracks));
            component = ((TextComponent.Builder)component.toBuilder().applyDeep(c -> {
                c.clickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + label + " group " + group.getName() + " info"));
                c.hoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)("Click to view more info about " + group.getName() + ".")).color(TextColor.GRAY)));
            })).build();
            sender.sendMessage((Component)component);
        });
        return CommandResult.SUCCESS;
    }
}

