/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Paginated;
import me.lucko.luckperms.common.utils.Predicates;

public class LogGroupHistory
extends SubCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogGroupHistory(LocaleManager locale) {
        super(CommandSpec.LOG_GROUP_HISTORY.localize(locale), "grouphistory", CommandPermission.LOG_GROUP_HISTORY, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, List<String> args, String label) {
        String group = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(group)) {
            Message.GROUP_INVALID_ENTRY.send(sender, group);
            return CommandResult.INVALID_ARGS;
        }
        Paginated<ExtendedLogEntry> content = new Paginated<ExtendedLogEntry>(log.getGroupHistory(group));
        int page = ArgumentParser.parseIntOrElse(1, args, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            return LogGroupHistory.showLog(page, sender, content);
        }
        return LogGroupHistory.showLog(content.getMaxPages(10), sender, content);
    }

    private static CommandResult showLog(int page, Sender sender, Paginated<ExtendedLogEntry> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        if (page == Integer.MIN_VALUE) {
            page = maxPage;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        SortedMap<Integer, ExtendedLogEntry> entries = log.getPage(page, 10);
        String name = entries.values().stream().findAny().get().getActedName();
        Message.LOG_HISTORY_GROUP_HEADER.send(sender, name, page, maxPage);
        long now = System.currentTimeMillis() / 1000L;
        for (Map.Entry<Integer, ExtendedLogEntry> e : entries.entrySet()) {
            long time = e.getValue().getTimestamp();
            Message.LOG_ENTRY.send(sender, e.getKey(), DurationFormatter.CONCISE_LOW_ACCURACY.format(now - time), e.getValue().getActorFriendlyString(), Character.toString(e.getValue().getType().getCode()), e.getValue().getActedFriendlyString(), e.getValue().getAction());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete(args);
    }
}

