/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class LogNotify
extends SubCommand<Log> {
    private static final String IGNORE_NODE = "luckperms.log.notify.ignoring";

    public LogNotify(LocaleManager locale) {
        super(CommandSpec.LOG_NOTIFY.localize(locale), "notify", CommandPermission.LOG_NOTIFY, Predicates.notInRange(0, 1));
    }

    public static boolean isIgnoring(LuckPermsPlugin plugin, UUID uuid) {
        User user = plugin.getUserManager().getIfLoaded(uuid);
        if (user == null) {
            return false;
        }
        Optional<LocalizedNode> ret = user.enduringData().immutable().get((Object)ContextSet.empty()).stream().filter(n -> n.getPermission().equalsIgnoreCase(IGNORE_NODE)).findFirst();
        return ret.map(Node::getValue).orElse(false);
    }

    private static void setIgnoring(LuckPermsPlugin plugin, UUID uuid, boolean state) {
        User user = plugin.getUserManager().getIfLoaded(uuid);
        if (user == null) {
            return;
        }
        if (state) {
            user.setPermission(NodeFactory.make(IGNORE_NODE));
        } else {
            user.removeIf(ContextSet.empty(), n -> n.getPermission().equalsIgnoreCase(IGNORE_NODE));
        }
        plugin.getStorage().saveUser(user).join();
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, List<String> args, String label) {
        if (sender.isConsole() || sender.isImport()) {
            Message.LOG_NOTIFY_CONSOLE.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        UUID uuid = sender.getUuid();
        if (args.isEmpty()) {
            if (LogNotify.isIgnoring(plugin, uuid)) {
                LogNotify.setIgnoring(plugin, uuid, false);
                Message.LOG_NOTIFY_TOGGLE_ON.send(sender, new Object[0]);
                return CommandResult.SUCCESS;
            }
            LogNotify.setIgnoring(plugin, uuid, true);
            Message.LOG_NOTIFY_TOGGLE_OFF.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        if (args.get(0).equalsIgnoreCase("on")) {
            if (!LogNotify.isIgnoring(plugin, uuid)) {
                Message.LOG_NOTIFY_ALREADY_ON.send(sender, new Object[0]);
                return CommandResult.STATE_ERROR;
            }
            LogNotify.setIgnoring(plugin, uuid, false);
            Message.LOG_NOTIFY_TOGGLE_ON.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        if (args.get(0).equalsIgnoreCase("off")) {
            if (LogNotify.isIgnoring(plugin, uuid)) {
                Message.LOG_NOTIFY_ALREADY_OFF.send(sender, new Object[0]);
                return CommandResult.STATE_ERROR;
            }
            LogNotify.setIgnoring(plugin, uuid, true);
            Message.LOG_NOTIFY_TOGGLE_OFF.send(sender, new Object[0]);
            return CommandResult.SUCCESS;
        }
        Message.LOG_NOTIFY_UNKNOWN.send(sender, new Object[0]);
        return CommandResult.INVALID_ARGS;
    }
}

