/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.web.WebEditor;

public class ApplyEditsCommand
extends SingleCommand {
    public ApplyEditsCommand(LocaleManager locale) {
        super(CommandSpec.APPLY_EDITS.localize(locale), "ApplyEdits", CommandPermission.APPLY_EDITS, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        String code = args.get(0);
        if (code.isEmpty()) {
            Message.APPLY_EDITS_INVALID_CODE.send(sender, code);
            return CommandResult.INVALID_ARGS;
        }
        JsonObject data = WebEditor.getDataFromGist(code);
        if (data == null) {
            Message.APPLY_EDITS_UNABLE_TO_READ.send(sender, code);
            return CommandResult.FAILURE;
        }
        boolean success = false;
        if (data.has("tabs") && data.get("tabs").isJsonArray()) {
            JsonArray rows = data.get("tabs").getAsJsonArray();
            for (JsonElement row : rows) {
                if (!this.read(row.getAsJsonObject(), sender, plugin)) continue;
                success = true;
            }
        } else {
            success = this.read(data, sender, plugin);
        }
        if (!success) {
            Message.APPLY_EDITS_TARGET_NO_CHANGES_PRESENT.send(sender, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    private boolean read(JsonObject data, Sender sender, LuckPermsPlugin plugin) {
        if (!data.has("who") || data.get("who").getAsString().isEmpty()) {
            Message.APPLY_EDITS_NO_TARGET.send(sender, new Object[0]);
            return false;
        }
        String who = data.get("who").getAsString();
        PermissionHolder holder = WebEditor.getHolderFromIdentifier(plugin, sender, who);
        if (holder == null) {
            return false;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return false;
        }
        Set<NodeDataContainer> nodes = WebEditor.deserializePermissions(data.getAsJsonArray("nodes"));
        HashSet<Node> before = new HashSet<Node>((Collection<Node>)holder.enduringData().immutable().values());
        Set<Node> after = nodes.stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
        Map.Entry<Set<Node>, Set<Node>> diff = ApplyEditsCommand.diff(before, after);
        Set<Node> diffAdded = diff.getKey();
        Set<Node> diffRemoved = diff.getValue();
        int additions = diffAdded.size();
        int deletions = diffRemoved.size();
        if (additions == 0 && deletions == 0) {
            return false;
        }
        holder.setNodes(NodeMapType.ENDURING, after);
        for (Node n : diffAdded) {
            ExtendedLogEntry.build().actor(sender).acted(holder).action("webeditor", "add", n.getPermission(), n.getValue(), n.getFullContexts()).build().submit(plugin, sender);
        }
        for (Node n : diffRemoved) {
            ExtendedLogEntry.build().actor(sender).acted(holder).action("webeditor", "remove", n.getPermission(), n.getValue(), n.getFullContexts()).build().submit(plugin, sender);
        }
        String additionsSummary = "addition" + (additions == 1 ? "" : "s");
        String deletionsSummary = "deletion" + (deletions == 1 ? "" : "s");
        Message.APPLY_EDITS_SUCCESS.send(sender, holder.getFormattedDisplayName());
        Message.APPLY_EDITS_SUCCESS_SUMMARY.send(sender, additions, additionsSummary, deletions, deletionsSummary);
        for (Node n : diffAdded) {
            Message.APPLY_EDITS_DIFF_ADDED.send(sender, ApplyEditsCommand.formatNode(plugin.getLocaleManager(), n));
        }
        for (Node n : diffRemoved) {
            Message.APPLY_EDITS_DIFF_REMOVED.send(sender, ApplyEditsCommand.formatNode(plugin.getLocaleManager(), n));
        }
        StorageAssistant.save(holder, sender, plugin);
        return true;
    }

    private static String formatNode(LocaleManager localeManager, Node n) {
        return n.getPermission() + " &7(" + (n.getValue() ? "&a" : "&c") + n.getValue() + "&7)" + MessageUtils.getAppendableNodeContextString(localeManager, n) + (n.isTemporary() ? " &7(" + DurationFormatter.CONCISE.formatDateDiff(n.getExpiryUnixTime()) + ")" : "");
    }

    private static Map.Entry<Set<Node>, Set<Node>> diff(Set<Node> before, Set<Node> after) {
        HashSet<Node> added = new HashSet<Node>(after);
        added.removeAll(before);
        HashSet<Node> removed = new HashSet<Node>(before);
        removed.removeAll(after);
        return Maps.immutableEntry(added, removed);
    }

    @Override
    public boolean shouldDisplay() {
        return false;
    }
}

