/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import java.util.List;
import java.util.function.Predicate;
import me.lucko.luckperms.api.DemotionResult;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.Predicates;

public class UserDemote
extends SubCommand<User> {
    public UserDemote(LocaleManager locale) {
        super(CommandSpec.USER_DEMOTE.localize(locale), "demote", CommandPermission.USER_DEMOTE, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, User user, List<String> args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), user)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        boolean removeFromFirst = !args.remove("--dont-remove-from-first");
        String trackName = args.get(0).toLowerCase();
        if (!DataConstraints.TRACK_NAME_TEST.test(trackName)) {
            Message.TRACK_INVALID_ENTRY.send(sender, trackName);
            return CommandResult.INVALID_ARGS;
        }
        Track track = StorageAssistant.loadTrack(trackName, sender, plugin);
        if (track == null) {
            return CommandResult.LOADING_ERROR;
        }
        if (track.getSize() <= 1) {
            Message.TRACK_EMPTY.send(sender, track.getName());
            return CommandResult.STATE_ERROR;
        }
        boolean silent = args.remove("-s");
        MutableContextSet context = ArgumentParser.parseContext(1, args, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, this.getPermission().get(), context)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Predicate<String> previousGroupPermissionChecker = s -> !ArgumentPermissions.checkArguments(plugin, sender, this.getPermission().get(), track.getName(), s) && !ArgumentPermissions.checkGroup(plugin, sender, s, (ContextSet)context);
        DemotionResult result = track.demote(user, context, previousGroupPermissionChecker, sender, removeFromFirst);
        switch (result.getStatus()) {
            case NOT_ON_TRACK: {
                Message.USER_TRACK_ERROR_NOT_CONTAIN_GROUP.send(sender, user.getFormattedDisplayName(), track.getName());
                return CommandResult.FAILURE;
            }
            case AMBIGUOUS_CALL: {
                Message.TRACK_AMBIGUOUS_CALL.send(sender, user.getFormattedDisplayName());
                return CommandResult.FAILURE;
            }
            case UNDEFINED_FAILURE: {
                Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
                return CommandResult.NO_PERMISSION;
            }
            case MALFORMED_TRACK: {
                Message.USER_DEMOTE_ERROR_MALFORMED.send(sender, result.getGroupTo().get());
                return CommandResult.LOADING_ERROR;
            }
            case REMOVED_FROM_FIRST_GROUP: {
                if (!removeFromFirst && !result.getGroupFrom().isPresent()) {
                    Message.USER_DEMOTE_ENDOFTRACK_NOT_REMOVED.send(sender, track.getName(), user.getFormattedDisplayName());
                    return CommandResult.STATE_ERROR;
                }
                Message.USER_DEMOTE_ENDOFTRACK.send(sender, track.getName(), user.getFormattedDisplayName(), result.getGroupFrom().get());
                ExtendedLogEntry.build().actor(sender).acted(user).action("demote", track.getName(), context).build().submit(plugin, sender);
                StorageAssistant.save(user, sender, plugin);
                return CommandResult.SUCCESS;
            }
            case SUCCESS: {
                String groupFrom = result.getGroupFrom().get();
                String groupTo = result.getGroupTo().get();
                Message.USER_DEMOTE_SUCCESS.send(sender, user.getFormattedDisplayName(), track.getName(), groupFrom, groupTo, MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
                if (!silent) {
                    Message.EMPTY.send(sender, MessageUtils.listToArrowSep(track.getGroups(), groupTo, groupFrom, true));
                }
                ExtendedLogEntry.build().actor(sender).acted(user).action("demote", track.getName(), context).build().submit(plugin, sender);
                StorageAssistant.save(user, sender, plugin);
                return CommandResult.SUCCESS;
            }
        }
        throw new AssertionError((Object)("Unknown status: " + result.getStatus()));
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.tracks(plugin)).complete(args);
    }
}

