/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.MainCommand;
import me.lucko.luckperms.common.commands.generic.meta.CommandMeta;
import me.lucko.luckperms.common.commands.generic.other.HolderClear;
import me.lucko.luckperms.common.commands.generic.other.HolderEditor;
import me.lucko.luckperms.common.commands.generic.other.HolderShowTracks;
import me.lucko.luckperms.common.commands.generic.parent.CommandParent;
import me.lucko.luckperms.common.commands.generic.permission.CommandPermission;
import me.lucko.luckperms.common.commands.user.UserClone;
import me.lucko.luckperms.common.commands.user.UserDemote;
import me.lucko.luckperms.common.commands.user.UserInfo;
import me.lucko.luckperms.common.commands.user.UserPromote;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.Uuids;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;

public class UserMainCommand
extends MainCommand<User, UserIdentifier> {
    private final LoadingCache<UUID, ReentrantLock> locks = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(key -> new ReentrantLock());

    public UserMainCommand(LocaleManager locale) {
        super(CommandSpec.USER.localize(locale), "User", 2, ImmutableList.builder().add((Object)new UserInfo(locale)).add(new CommandPermission(locale, true)).add(new CommandParent(locale, true)).add(new CommandMeta(locale, true)).add(new HolderEditor(locale, true)).add((Object)new UserPromote(locale)).add((Object)new UserDemote(locale)).add(new HolderShowTracks(locale, true)).add(new HolderClear(locale, true)).add((Object)new UserClone(locale)).build());
    }

    public static UUID parseTargetUuid(String target, LuckPermsPlugin plugin, Sender sender) {
        UUID uuid = Uuids.parse(target);
        if (uuid == null) {
            if (!plugin.getConfiguration().get(ConfigKeys.ALLOW_INVALID_USERNAMES).booleanValue()) {
                if (!DataConstraints.PLAYER_USERNAME_TEST.test(target)) {
                    Message.USER_INVALID_ENTRY.send(sender, target);
                    return null;
                }
            } else if (!DataConstraints.PLAYER_USERNAME_TEST_LENIENT.test(target)) {
                Message.USER_INVALID_ENTRY.send(sender, target);
                return null;
            }
            if ((uuid = plugin.getStorage().getPlayerUuid(target.toLowerCase()).join()) == null) {
                if (!plugin.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue()) {
                    Message.USER_NOT_FOUND.send(sender, target);
                    return null;
                }
                uuid = plugin.getBootstrap().lookupUuid(target).orElse(null);
                if (uuid == null) {
                    Message.USER_NOT_FOUND.send(sender, target);
                    return null;
                }
            }
        }
        return uuid;
    }

    @Override
    protected UserIdentifier parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        UUID uuid = UserMainCommand.parseTargetUuid(target, plugin, sender);
        if (uuid == null) {
            return null;
        }
        String name = plugin.getStorage().getPlayerName(uuid).join();
        return UserIdentifier.of(uuid, name);
    }

    @Override
    protected User getTarget(UserIdentifier target, LuckPermsPlugin plugin, Sender sender) {
        User user = plugin.getStorage().loadUser(target.getUuid(), target.getUsername().orElse(null)).join();
        user.auditTemporaryPermissions();
        return user;
    }

    @Override
    protected ReentrantLock getLockForTarget(UserIdentifier target) {
        return (ReentrantLock)this.locks.get((Object)target.getUuid());
    }

    @Override
    protected void cleanup(User user, LuckPermsPlugin plugin) {
        plugin.getUserManager().cleanup(user);
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return plugin.getBootstrap().getPlayerList().collect(Collectors.toList());
    }
}

